// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../@material/base/types
//   ../../../@material/base/component
//   ../../../@material/floating-label/index
//   ../../../@material/line-ripple/index
//   ../../../@material/notched-outline/index
//   ../../../@material/ripple/component
//   ../../../@material/ripple/types
//   ../../../@material/base/foundation

declare module 'mdc-textfield' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-textfield/adapter';
    export * from 'mdc-textfield/component';
    export * from 'mdc-textfield/foundation';
    export * from 'mdc-textfield/types';
    export * from 'mdc-textfield/character-counter/index';
    export * from 'mdc-textfield/helper-text/index';
    export * from 'mdc-textfield/icon/index';
}

declare module 'mdc-textfield/adapter' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventType, SpecificEventListener } from '@material/base/types';
    import { MDCTextFieldNativeInputElement } from 'mdc-textfield/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTextFieldAdapter extends MDCTextFieldRootAdapter, MDCTextFieldInputAdapter, MDCTextFieldLabelAdapter, MDCTextFieldLineRippleAdapter, MDCTextFieldOutlineAdapter {
    }
    export interface MDCTextFieldRootAdapter {
            /**
                * Adds a class to the root Element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root Element.
                */
            removeClass(className: string): void;
            /**
                * @return true if the root element contains the given class name.
                */
            hasClass(className: string): boolean;
            /**
                * Registers an event handler on the root element for a given event.
                */
            registerTextFieldInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event handler on the root element for a given event.
                */
            deregisterTextFieldInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Registers a validation attribute change listener on the input element.
                * Handler accepts list of attribute names.
                */
            registerValidationAttributeChangeHandler(handler: (attributeNames: string[]) => void): MutationObserver;
            /**
                * Disconnects a validation attribute observer on the input element.
                */
            deregisterValidationAttributeChangeHandler(observer: MutationObserver): void;
    }
    export interface MDCTextFieldInputAdapter {
            /**
                * @return The native `<input>` element, or an object with the same shape.
                * Note that this method can return null, which the foundation will handle gracefully.
                */
            getNativeInput(): MDCTextFieldNativeInputElement | null;
            /**
                * @return true if the textfield is focused. We achieve this via `document.activeElement === this.root_`.
                */
            isFocused(): boolean;
            /**
                * Registers an event listener on the native input element for a given event.
                */
            registerInputInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event listener on the native input element for a given event.
                */
            deregisterInputInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
    }
    export interface MDCTextFieldLabelAdapter {
            /**
                * Only implement if label exists.
                * Shakes label if shouldShake is true.
                */
            shakeLabel(shouldShake: boolean): void;
            /**
                * Only implement if label exists.
                * Floats the label above the input element if shouldFloat is true.
                */
            floatLabel(shouldFloat: boolean): void;
            /**
                * @return true if label element exists, false if it doesn't.
                */
            hasLabel(): boolean;
            /**
                * Only implement if label exists.
                * @return width of label in pixels.
                */
            getLabelWidth(): number;
    }
    export interface MDCTextFieldLineRippleAdapter {
            /**
                * Activates the line ripple.
                */
            activateLineRipple(): void;
            /**
                * Deactivates the line ripple.
                */
            deactivateLineRipple(): void;
            /**
                * Sets the transform origin of the line ripple.
                */
            setLineRippleTransformOrigin(normalizedX: number): void;
    }
    export interface MDCTextFieldOutlineAdapter {
            /**
                * @return true if outline element exists, false if it doesn't.
                */
            hasOutline(): boolean;
            /**
                * Only implement if outline element exists.
                */
            notchOutline(labelWidth: number): void;
            /**
                * Only implement if outline element exists.
                * Closes notch in outline element.
                */
            closeOutline(): void;
    }
}

declare module 'mdc-textfield/component' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCFloatingLabelFactory } from '@material/floating-label/index';
    import { MDCLineRippleFactory } from '@material/line-ripple/index';
    import { MDCNotchedOutlineFactory } from '@material/notched-outline/index';
    import { MDCRipple, MDCRippleFactory } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCTextFieldCharacterCounterFactory } from 'mdc-textfield/character-counter/index';
    import { MDCTextFieldFoundation } from 'mdc-textfield/foundation';
    import { MDCTextFieldHelperTextFactory } from 'mdc-textfield/helper-text/index';
    import { MDCTextFieldIconFactory } from 'mdc-textfield/icon/index';
    export class MDCTextField extends MDCComponent<MDCTextFieldFoundation> implements MDCRippleCapableSurface {
            static attachTo(root: Element): MDCTextField;
            root_: HTMLElement;
            ripple: MDCRipple | null;
            initialize(rippleFactory?: MDCRippleFactory, lineRippleFactory?: MDCLineRippleFactory, helperTextFactory?: MDCTextFieldHelperTextFactory, characterCounterFactory?: MDCTextFieldCharacterCounterFactory, iconFactory?: MDCTextFieldIconFactory, labelFactory?: MDCFloatingLabelFactory, outlineFactory?: MDCNotchedOutlineFactory): void;
            destroy(): void;
            /**
                * Initializes the Text Field's internal state based on the environment's
                * state.
                */
            initialSyncWithDom(): void;
            /**
             * @param value The value to set on the input.
             */
            value: string;
            /**
             * @param disabled Sets the Text Field disabled or enabled.
             */
            disabled: boolean;
            /**
             * @param valid Sets the Text Field valid or invalid.
             */
            valid: boolean;
            /**
             * @param required Sets the Text Field to required.
             */
            required: boolean;
            /**
             * @param pattern Sets the input element's validation pattern.
             */
            pattern: string;
            /**
             * @param minLength Sets the input element's minLength.
             */
            minLength: number;
            /**
             * @param maxLength Sets the input element's maxLength.
             */
            maxLength: number;
            /**
             * @param min Sets the input element's min.
             */
            min: string;
            /**
             * @param max Sets the input element's max.
             */
            max: string;
            /**
             * @param step Sets the input element's step.
             */
            step: string;
            /**
                * Sets the helper text element content.
                */
            helperTextContent: string;
            /**
                * Sets the aria label of the leading icon.
                */
            leadingIconAriaLabel: string;
            /**
                * Sets the text content of the leading icon.
                */
            leadingIconContent: string;
            /**
                * Sets the aria label of the trailing icon.
                */
            trailingIconAriaLabel: string;
            /**
                * Sets the text content of the trailing icon.
                */
            trailingIconContent: string;
            /**
                * Enables or disables the use of native validation. Use this for custom validation.
                * @param useNativeValidation Set this to false to ignore native input validation.
                */
            useNativeValidation: boolean;
            /**
                * Focuses the input element.
                */
            focus(): void;
            /**
                * Recomputes the outline SVG path for the outline element.
                */
            layout(): void;
            getDefaultFoundation(): MDCTextFieldFoundation;
    }
}

declare module 'mdc-textfield/foundation' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTextFieldAdapter } from 'mdc-textfield/adapter';
    import { MDCTextFieldFoundationMap } from 'mdc-textfield/types';
    export class MDCTextFieldFoundation extends MDCFoundation<MDCTextFieldAdapter> {
            static readonly cssClasses: {
                    DENSE: string;
                    DISABLED: string;
                    FOCUSED: string;
                    HELPER_LINE: string;
                    INVALID: string;
                    OUTLINED: string;
                    ROOT: string;
                    TEXTAREA: string;
                    WITH_LEADING_ICON: string;
            };
            static readonly strings: {
                    ARIA_CONTROLS: string;
                    ICON_SELECTOR: string;
                    INPUT_SELECTOR: string;
                    LABEL_SELECTOR: string;
                    LINE_RIPPLE_SELECTOR: string;
                    OUTLINE_SELECTOR: string;
            };
            static readonly numbers: {
                    DENSE_LABEL_SCALE: number;
                    LABEL_SCALE: number;
            };
            readonly shouldShake: boolean;
            readonly shouldFloat: boolean;
            /**
                * See {@link MDCTextFieldAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCTextFieldAdapter;
            /**
                * @param adapter
                * @param foundationMap Map from subcomponent names to their subfoundations.
                */
            constructor(adapter?: Partial<MDCTextFieldAdapter>, foundationMap?: Partial<MDCTextFieldFoundationMap>);
            init(): void;
            destroy(): void;
            /**
                * Handles user interactions with the Text Field.
                */
            handleTextFieldInteraction(): void;
            /**
                * Handles validation attribute changes
                */
            handleValidationAttributeChange(attributesList: string[]): void;
            /**
                * Opens/closes the notched outline.
                */
            notchOutline(openNotch: boolean): void;
            /**
                * Activates the text field focus state.
                */
            activateFocus(): void;
            /**
                * Sets the line ripple's transform origin, so that the line ripple activate
                * animation will animate out from the user's click location.
                */
            setTransformOrigin(evt: TouchEvent | MouseEvent): void;
            /**
                * Handles input change of text input and text area.
                */
            handleInput(): void;
            /**
                * Activates the Text Field's focus state in cases when the input value
                * changes without user input (e.g. programmatically).
                */
            autoCompleteFocus(): void;
            /**
                * Deactivates the Text Field's focus state.
                */
            deactivateFocus(): void;
            getValue(): string;
            /**
                * @param value The value to set on the input Element.
                */
            setValue(value: string): void;
            /**
                * @return The custom validity state, if set; otherwise, the result of a native validity check.
                */
            isValid(): boolean;
            /**
                * @param isValid Sets the custom validity state of the Text Field.
                */
            setValid(isValid: boolean): void;
            /**
                * Enables or disables the use of native validation. Use this for custom validation.
                * @param useNativeValidation Set this to false to ignore native input validation.
                */
            setUseNativeValidation(useNativeValidation: boolean): void;
            isDisabled(): boolean;
            /**
                * @param disabled Sets the text-field disabled or enabled.
                */
            setDisabled(disabled: boolean): void;
            /**
                * @param content Sets the content of the helper text.
                */
            setHelperTextContent(content: string): void;
            /**
                * Sets the aria label of the leading icon.
                */
            setLeadingIconAriaLabel(label: string): void;
            /**
                * Sets the text content of the leading icon.
                */
            setLeadingIconContent(content: string): void;
            /**
                * Sets the aria label of the trailing icon.
                */
            setTrailingIconAriaLabel(label: string): void;
            /**
                * Sets the text content of the trailing icon.
                */
            setTrailingIconContent(content: string): void;
    }
    export default MDCTextFieldFoundation;
}

declare module 'mdc-textfield/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCTextFieldCharacterCounterFoundation } from 'mdc-textfield/character-counter/foundation';
    import { MDCTextFieldHelperTextFoundation } from 'mdc-textfield/helper-text/foundation';
    import { MDCTextFieldIconFoundation } from 'mdc-textfield/icon/foundation';
    export type MDCTextFieldNativeInputElement = Pick<HTMLInputElement, 'disabled' | 'maxLength' | 'type' | 'value'> & {
        validity: Pick<ValidityState, 'badInput' | 'valid'>;
    };
    export interface MDCTextFieldFoundationMap {
        helperText: MDCTextFieldHelperTextFoundation;
        characterCounter: MDCTextFieldCharacterCounterFoundation;
        leadingIcon: MDCTextFieldIconFoundation;
        trailingIcon: MDCTextFieldIconFoundation;
    }
}

declare module 'mdc-textfield/character-counter/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-textfield/character-counter/adapter';
    export * from 'mdc-textfield/character-counter/component';
    export * from 'mdc-textfield/character-counter/foundation';
}

declare module 'mdc-textfield/helper-text/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-textfield/helper-text/adapter';
    export * from 'mdc-textfield/helper-text/component';
    export * from 'mdc-textfield/helper-text/foundation';
}

declare module 'mdc-textfield/icon/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-textfield/icon/adapter';
    export * from 'mdc-textfield/icon/component';
    export * from 'mdc-textfield/icon/foundation';
}

declare module 'mdc-textfield/character-counter/foundation' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTextFieldCharacterCounterAdapter } from 'mdc-textfield/character-counter/adapter';
    export class MDCTextFieldCharacterCounterFoundation extends MDCFoundation<MDCTextFieldCharacterCounterAdapter> {
            static readonly cssClasses: {
                    ROOT: string;
            };
            static readonly strings: {
                    ROOT_SELECTOR: string;
            };
            /**
                * See {@link MDCTextFieldCharacterCounterAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCTextFieldCharacterCounterAdapter;
            constructor(adapter?: Partial<MDCTextFieldCharacterCounterAdapter>);
            setCounterValue(currentLength: number, maxLength: number): void;
    }
    export default MDCTextFieldCharacterCounterFoundation;
}

declare module 'mdc-textfield/helper-text/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTextFieldHelperTextAdapter } from 'mdc-textfield/helper-text/adapter';
    export class MDCTextFieldHelperTextFoundation extends MDCFoundation<MDCTextFieldHelperTextAdapter> {
            static readonly cssClasses: {
                    HELPER_TEXT_PERSISTENT: string;
                    HELPER_TEXT_VALIDATION_MSG: string;
                    ROOT: string;
            };
            static readonly strings: {
                    ARIA_HIDDEN: string;
                    ROLE: string;
                    ROOT_SELECTOR: string;
            };
            /**
                * See {@link MDCTextFieldHelperTextAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCTextFieldHelperTextAdapter;
            constructor(adapter?: Partial<MDCTextFieldHelperTextAdapter>);
            /**
                * Sets the content of the helper text field.
                */
            setContent(content: string): void;
            /**
                * @param isPersistent Sets the persistency of the helper text.
                */
            setPersistent(isPersistent: boolean): void;
            /**
                * @param isValidation True to make the helper text act as an error validation message.
                */
            setValidation(isValidation: boolean): void;
            /**
                * Makes the helper text visible to the screen reader.
                */
            showToScreenReader(): void;
            /**
                * Sets the validity of the helper text based on the input validity.
                */
            setValidity(inputIsValid: boolean): void;
    }
    export default MDCTextFieldHelperTextFoundation;
}

declare module 'mdc-textfield/icon/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTextFieldIconAdapter } from 'mdc-textfield/icon/adapter';
    export class MDCTextFieldIconFoundation extends MDCFoundation<MDCTextFieldIconAdapter> {
            static readonly strings: {
                    ICON_EVENT: string;
                    ICON_ROLE: string;
            };
            /**
                * See {@link MDCTextFieldIconAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCTextFieldIconAdapter;
            constructor(adapter?: Partial<MDCTextFieldIconAdapter>);
            init(): void;
            destroy(): void;
            setDisabled(disabled: boolean): void;
            setAriaLabel(label: string): void;
            setContent(content: string): void;
            handleInteraction(evt: MouseEvent | KeyboardEvent): void;
    }
    export default MDCTextFieldIconFoundation;
}

declare module 'mdc-textfield/character-counter/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTextFieldCharacterCounterAdapter {
            /**
                * Sets the text content of character counter element.
                */
            setContent(content: string): void;
    }
}

declare module 'mdc-textfield/character-counter/component' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCTextFieldCharacterCounterFoundation } from 'mdc-textfield/character-counter/foundation';
    export type MDCTextFieldCharacterCounterFactory = (el: Element, foundation?: MDCTextFieldCharacterCounterFoundation) => MDCTextFieldCharacterCounter;
    export class MDCTextFieldCharacterCounter extends MDCComponent<MDCTextFieldCharacterCounterFoundation> {
        static attachTo(root: Element): MDCTextFieldCharacterCounter;
        readonly foundation: MDCTextFieldCharacterCounterFoundation;
        getDefaultFoundation(): MDCTextFieldCharacterCounterFoundation;
    }
}

declare module 'mdc-textfield/helper-text/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTextFieldHelperTextAdapter {
            /**
                * Adds a class to the helper text element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the helper text element.
                */
            removeClass(className: string): void;
            /**
                * Returns whether or not the helper text element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Sets an attribute with a given value on the helper text element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the helper text element.
                */
            removeAttr(attr: string): void;
            /**
                * Sets the text content for the helper text element.
                */
            setContent(content: string): void;
    }
}

declare module 'mdc-textfield/helper-text/component' {
    /**
      * @license
      * Copyright 2017 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCTextFieldHelperTextFoundation } from 'mdc-textfield/helper-text/foundation';
    export type MDCTextFieldHelperTextFactory = (el: Element, foundation?: MDCTextFieldHelperTextFoundation) => MDCTextFieldHelperText;
    export class MDCTextFieldHelperText extends MDCComponent<MDCTextFieldHelperTextFoundation> {
        static attachTo(root: Element): MDCTextFieldHelperText;
        readonly foundation: MDCTextFieldHelperTextFoundation;
        getDefaultFoundation(): MDCTextFieldHelperTextFoundation;
    }
}

declare module 'mdc-textfield/icon/adapter' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventType, SpecificEventListener } from '@material/base/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTextFieldIconAdapter {
            /**
                * Gets the value of an attribute on the icon element.
                */
            getAttr(attr: string): string | null;
            /**
                * Sets an attribute on the icon element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the icon element.
                */
            removeAttr(attr: string): void;
            /**
                * Sets the text content of the icon element.
                */
            setContent(content: string): void;
            /**
                * Registers an event listener on the icon element for a given event.
                */
            registerInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event listener on the icon element for a given event.
                */
            deregisterInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Emits a custom event "MDCTextField:icon" denoting a user has clicked the icon.
                */
            notifyIconAction(): void;
    }
}

declare module 'mdc-textfield/icon/component' {
    /**
      * @license
      * Copyright 2017 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCTextFieldIconFoundation } from 'mdc-textfield/icon/foundation';
    export type MDCTextFieldIconFactory = (el: Element, foundation?: MDCTextFieldIconFoundation) => MDCTextFieldIcon;
    export class MDCTextFieldIcon extends MDCComponent<MDCTextFieldIconFoundation> {
        static attachTo(root: Element): MDCTextFieldIcon;
        readonly foundation: MDCTextFieldIconFoundation;
        getDefaultFoundation(): MDCTextFieldIconFoundation;
    }
}

