// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../@material/base/types
//   ../../../@material/base/component
//   ../../../@material/ripple/component
//   ../../../@material/base/foundation

declare module 'mdc-top-app-bar' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-top-app-bar/adapter';
    export * from 'mdc-top-app-bar/component';
    export * from 'mdc-top-app-bar/foundation';
    export * from 'mdc-top-app-bar/fixed/foundation';
    export * from 'mdc-top-app-bar/short/foundation';
    export * from 'mdc-top-app-bar/standard/foundation';
}

declare module 'mdc-top-app-bar/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventType, SpecificEventListener } from '@material/base/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTopAppBarAdapter {
            /**
                * Adds a class to the root Element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root Element.
                */
            removeClass(className: string): void;
            /**
                * Returns true if the root Element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Sets the specified inline style property on the root Element to the given value.
                */
            setStyle(property: string, value: string): void;
            /**
                * Gets the height of the top app bar.
                */
            getTopAppBarHeight(): number;
            /**
                * Registers an event handler on the navigation icon element for a given event.
                */
            registerNavigationIconInteractionHandler<K extends EventType>(type: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event handler on the navigation icon element for a given event.
                */
            deregisterNavigationIconInteractionHandler<K extends EventType>(type: K, handler: SpecificEventListener<K>): void;
            /**
                * Emits an event when the navigation icon is clicked.
                */
            notifyNavigationIconClicked(): void;
            registerScrollHandler(handler: SpecificEventListener<'scroll'>): void;
            deregisterScrollHandler(handler: SpecificEventListener<'scroll'>): void;
            registerResizeHandler(handler: SpecificEventListener<'resize'>): void;
            deregisterResizeHandler(handler: SpecificEventListener<'resize'>): void;
            getViewportScrollY(): number;
            getTotalActionItems(): number;
    }
}

declare module 'mdc-top-app-bar/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCRippleFactory } from '@material/ripple/component';
    import { MDCTopAppBarBaseFoundation } from 'mdc-top-app-bar/foundation';
    export class MDCTopAppBar extends MDCComponent<MDCTopAppBarBaseFoundation> {
        static attachTo(root: Element): MDCTopAppBar;
        initialize(rippleFactory?: MDCRippleFactory): void;
        destroy(): void;
        setScrollTarget(target: EventTarget): void;
        getDefaultFoundation(): MDCTopAppBarBaseFoundation;
    }
}

declare module 'mdc-top-app-bar/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { SpecificEventListener } from '@material/base/types';
    import { MDCTopAppBarAdapter } from 'mdc-top-app-bar/adapter';
    export class MDCTopAppBarBaseFoundation extends MDCFoundation<MDCTopAppBarAdapter> {
            static readonly strings: {
                    ACTION_ITEM_SELECTOR: string;
                    NAVIGATION_EVENT: string;
                    NAVIGATION_ICON_SELECTOR: string;
                    ROOT_SELECTOR: string;
                    TITLE_SELECTOR: string;
            };
            static readonly cssClasses: {
                    FIXED_CLASS: string;
                    FIXED_SCROLLED_CLASS: string;
                    SHORT_CLASS: string;
                    SHORT_COLLAPSED_CLASS: string;
                    SHORT_HAS_ACTION_ITEM_CLASS: string;
            };
            static readonly numbers: {
                    DEBOUNCE_THROTTLE_RESIZE_TIME_MS: number;
                    MAX_TOP_APP_BAR_HEIGHT: number;
            };
            /**
                * See {@link MDCTopAppBarAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCTopAppBarAdapter;
            protected scrollHandler_?: SpecificEventListener<'scroll'>;
            protected resizeHandler_?: SpecificEventListener<'resize'>;
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            init(): void;
            destroy(): void;
            initScrollHandler(): void;
            destroyScrollHandler(): void;
    }
    export default MDCTopAppBarBaseFoundation;
}

declare module 'mdc-top-app-bar/fixed/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarAdapter } from 'mdc-top-app-bar/adapter';
    import { MDCTopAppBarFoundation } from 'mdc-top-app-bar/standard/foundation';
    export class MDCFixedTopAppBarFoundation extends MDCTopAppBarFoundation {
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            /**
                * Scroll handler for applying/removing the modifier class on the fixed top app bar.
                */
            fixedScrollHandler_(): void;
    }
    export default MDCFixedTopAppBarFoundation;
}

declare module 'mdc-top-app-bar/short/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarAdapter } from 'mdc-top-app-bar/adapter';
    import { MDCTopAppBarBaseFoundation } from 'mdc-top-app-bar/foundation';
    export class MDCShortTopAppBarFoundation extends MDCTopAppBarBaseFoundation {
            /**
                * State variable for the current top app bar state
                */
            isCollapsed: boolean;
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            init(): void;
            destroy(): void;
    }
    export default MDCShortTopAppBarFoundation;
}

declare module 'mdc-top-app-bar/standard/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarAdapter } from 'mdc-top-app-bar/adapter';
    import { MDCTopAppBarBaseFoundation } from 'mdc-top-app-bar/foundation';
    export class MDCTopAppBarFoundation extends MDCTopAppBarBaseFoundation {
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            destroy(): void;
    }
    export default MDCTopAppBarFoundation;
}

