// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/ripple/component
//   ../../@material/base/foundation

declare module '@material/top-app-bar' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/top-app-bar/adapter';
    export * from '@material/top-app-bar/component';
    export * from '@material/top-app-bar/constants';
    export * from '@material/top-app-bar/foundation';
    export * from '@material/top-app-bar/fixed/foundation';
    export * from '@material/top-app-bar/short/foundation';
    export * from '@material/top-app-bar/standard/foundation';
}

declare module '@material/top-app-bar/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTopAppBarAdapter {
            /**
                * Adds a class to the root Element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root Element.
                */
            removeClass(className: string): void;
            /**
                * Returns true if the root Element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Sets the specified inline style property on the root Element to the given value.
                */
            setStyle(property: string, value: string): void;
            /**
                * Gets the height of the top app bar.
                */
            getTopAppBarHeight(): number;
            getViewportScrollY(): number;
            getTotalActionItems(): number;
            /**
                * Emits an event when the navigation icon is clicked.
                */
            notifyNavigationIconClicked(): void;
    }
}

declare module '@material/top-app-bar/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCRippleFactory } from '@material/ripple/component';
    import { MDCTopAppBarBaseFoundation } from '@material/top-app-bar/foundation';
    export class MDCTopAppBar extends MDCComponent<MDCTopAppBarBaseFoundation> {
        static attachTo(root: Element): MDCTopAppBar;
        initialize(rippleFactory?: MDCRippleFactory): void;
        initialSyncWithDOM(): void;
        destroy(): void;
        setScrollTarget(target: EventTarget): void;
        getDefaultFoundation(): MDCTopAppBarBaseFoundation;
    }
}

declare module '@material/top-app-bar/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        FIXED_CLASS: string;
        FIXED_SCROLLED_CLASS: string;
        SHORT_CLASS: string;
        SHORT_COLLAPSED_CLASS: string;
        SHORT_HAS_ACTION_ITEM_CLASS: string;
    };
    const numbers: {
        DEBOUNCE_THROTTLE_RESIZE_TIME_MS: number;
        MAX_TOP_APP_BAR_HEIGHT: number;
    };
    const strings: {
        ACTION_ITEM_SELECTOR: string;
        NAVIGATION_EVENT: string;
        NAVIGATION_ICON_SELECTOR: string;
        ROOT_SELECTOR: string;
        TITLE_SELECTOR: string;
    };
    export { cssClasses, numbers, strings };
}

declare module '@material/top-app-bar/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTopAppBarAdapter } from '@material/top-app-bar/adapter';
    export class MDCTopAppBarBaseFoundation extends MDCFoundation<MDCTopAppBarAdapter> {
            static get strings(): {
                    ACTION_ITEM_SELECTOR: string;
                    NAVIGATION_EVENT: string;
                    NAVIGATION_ICON_SELECTOR: string;
                    ROOT_SELECTOR: string;
                    TITLE_SELECTOR: string;
            };
            static get cssClasses(): {
                    FIXED_CLASS: string;
                    FIXED_SCROLLED_CLASS: string;
                    SHORT_CLASS: string;
                    SHORT_COLLAPSED_CLASS: string;
                    SHORT_HAS_ACTION_ITEM_CLASS: string;
            };
            static get numbers(): {
                    DEBOUNCE_THROTTLE_RESIZE_TIME_MS: number;
                    MAX_TOP_APP_BAR_HEIGHT: number;
            };
            /**
                * See {@link MDCTopAppBarAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCTopAppBarAdapter;
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            /** Other variants of TopAppBar foundation overrides this method */
            handleTargetScroll(): void;
            /** Other variants of TopAppBar foundation overrides this method */
            handleWindowResize(): void;
            handleNavigationClick(): void;
    }
    export default MDCTopAppBarBaseFoundation;
}

declare module '@material/top-app-bar/fixed/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarFoundation } from '@material/top-app-bar/standard/foundation';
    export class MDCFixedTopAppBarFoundation extends MDCTopAppBarFoundation {
            /**
                * Scroll handler for applying/removing the modifier class on the fixed top app bar.
                * @override
                */
            handleTargetScroll(): void;
    }
    export default MDCFixedTopAppBarFoundation;
}

declare module '@material/top-app-bar/short/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarAdapter } from '@material/top-app-bar/adapter';
    import { MDCTopAppBarBaseFoundation } from '@material/top-app-bar/foundation';
    export class MDCShortTopAppBarFoundation extends MDCTopAppBarBaseFoundation {
            get isCollapsed(): boolean;
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            init(): void;
            /**
                * Set if the short top app bar should always be collapsed.
                *
                * @param value When `true`, bar will always be collapsed. When `false`, bar may collapse or expand based on scroll.
                */
            setAlwaysCollapsed(value: boolean): void;
            getAlwaysCollapsed(): boolean;
            /**
                * Scroll handler for applying/removing the collapsed modifier class on the short top app bar.
                * @override
                */
            handleTargetScroll(): void;
    }
    export default MDCShortTopAppBarFoundation;
}

declare module '@material/top-app-bar/standard/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTopAppBarAdapter } from '@material/top-app-bar/adapter';
    import { MDCTopAppBarBaseFoundation } from '@material/top-app-bar/foundation';
    export class MDCTopAppBarFoundation extends MDCTopAppBarBaseFoundation {
            constructor(adapter?: Partial<MDCTopAppBarAdapter>);
            destroy(): void;
            /**
                * Scroll handler for the default scroll behavior of the top app bar.
                * @override
                */
            handleTargetScroll(): void;
            /**
                * Top app bar resize handler that throttle/debounce functions that execute updates.
                * @override
                */
            handleWindowResize(): void;
    }
    export default MDCTopAppBarFoundation;
}

