<p align="center">
  <a href="https://materializeweb.com" target="_blank">
    <img src="https://materializeweb.com/images/materialize.svg" width="200">
  </a>
</p>

<h3 align="center">Materialize</h3>

<p align="center">
  Materialize, a CSS Framework based on Material Design.
  <br>
  <a target="_blank" href="https://materializeweb.com"><strong>[ Browse the docs ]</strong></a>
  <br>
  <br>
  <a href="https://github.com/materializecss/materialize/actions/">
    <img src="https://github.com/materializecss/materialize/actions/workflows/nightly.yml/badge.svg" alt="GitHub Actions badge">
  </a>
  <a href="https://www.npmjs.com/package/@materializecss/materialize">
    <img src="https://badge.fury.io/js/%40materializecss%2Fmaterialize.svg" alt="npm version badge">
  </a>
  <a href="https://www.jsdelivr.com/package/npm/@materializecss/materialize">
    <img src="https://data.jsdelivr.com/v1/package/npm/@materializecss/materialize/badge" alt="jsDelivr version badge">
  </a>
  <a href="https://gitter.im/materializecss/materialize">
    <img src="https://badges.gitter.im/Join%20Chat.svg" alt="Gitter badge">
  </a>
  <a href="https://opencollective.com/materialize">
    <img alt="Open Collective backers and sponsors" src="https://img.shields.io/opencollective/all/materialize">
  </a>
</p>

## Quickstart
Read the [getting started guide](https://materializeweb.com/getting-started.html) for more information on how to use materialize.

- [Download the latest release](https://github.com/materializecss/materialize/releases/latest) of materialize directly from GitHub. ([Beta](https://github.com/materializecss/materialize/releases/))
- Clone the repo: `git clone https://github.com/materializecss/materialize.git`
- Include the files via [jsDelivr](https://www.jsdelivr.com/package/npm/@materializecss/materialize).
- Install with [npm](https://www.npmjs.com): `npm install @materializecss/materialize` (Beta: `npm install @materializecss/materialize@next`)

## Development
The documentation can be found at <https://materializeweb.com>. To run the documentation locally on your machine, you need [Node.js](https://nodejs.org) installed on your computer.

This is the core project with all the components. To see how they are used we recommend using an example project or go to the documentation.
Otherwise, if you want to develop the components itself, the dev process of this core-repo works like this:
```sh
npm install
npm run dev
```

### Running documentation locally
See [Materialize Docs Repo](https://github.com/materializecss/materialize-docs) to see Materialize in Action.

### Documentation for previous releases
Previous releases are available [here](https://github.com/materializecss/materialize/releases).

## Release
If you want to release `materialize.css` or `materialize.js` from the latest commit, you can build the files with the following command after `npm install`. See `package.json` to check the current version like `1.0.0`.
```sh
npm run release -- --oldver=<current_version> --newver=<new_version>
```

## Supported Browsers:
Materialize is compatible with:

- Chrome 35+
- Firefox 31+
- Safari 9+
- Opera
- Edge

## Changelog
For changelogs, check out [the Releases section of materialize](https://github.com/materializecss/materialize/releases) or the [CHANGELOG.md](CHANGELOG.md).

## Testing
We use Jasmine as our testing framework and we're trying to write a robust test suite for our components. If you want to help, [here's a starting guide on how to write tests in Jasmine](CONTRIBUTING.md#jasmine-testing-guide).

## Contributing
Check out the [CONTRIBUTING document](CONTRIBUTING.md) in the root of the repository to learn how you can contribute. You can also browse the [help-wanted](https://github.com/materializecss/materialize/labels/help-wanted) tag in our issue tracker to find things to do.

## Sponsors
Support this project by becoming a sponsor. Your logo will show up here with a link to your website. [[Become a sponsor](https://opencollective.com/materialize#sponsor)]

[![OC sponsor 0](https://opencollective.com/materialize/sponsor/0/avatar.svg)](https://opencollective.com/materialize/sponsor/0/website)
[![OC sponsor 1](https://opencollective.com/materialize/sponsor/1/avatar.svg)](https://opencollective.com/materialize/sponsor/1/website)
[![OC sponsor 2](https://opencollective.com/materialize/sponsor/2/avatar.svg)](https://opencollective.com/materialize/sponsor/2/website)
[![OC sponsor 3](https://opencollective.com/materialize/sponsor/3/avatar.svg)](https://opencollective.com/materialize/sponsor/3/website)
[![OC sponsor 4](https://opencollective.com/materialize/sponsor/4/avatar.svg)](https://opencollective.com/materialize/sponsor/4/website)
[![OC sponsor 5](https://opencollective.com/materialize/sponsor/5/avatar.svg)](https://opencollective.com/materialize/sponsor/5/website)
[![OC sponsor 6](https://opencollective.com/materialize/sponsor/6/avatar.svg)](https://opencollective.com/materialize/sponsor/6/website)
[![OC sponsor 7](https://opencollective.com/materialize/sponsor/7/avatar.svg)](https://opencollective.com/materialize/sponsor/7/website)
[![OC sponsor 8](https://opencollective.com/materialize/sponsor/8/avatar.svg)](https://opencollective.com/materialize/sponsor/8/website)
[![OC sponsor 9](https://opencollective.com/materialize/sponsor/9/avatar.svg)](https://opencollective.com/materialize/sponsor/9/website)


## Backers
Thank you to all our backers! 🙏 [[Become a backer](https://opencollective.com/materialize#backer)]

[![Backers](https://opencollective.com/materialize/backers.svg?width=890)](https://opencollective.com/materialize#backers)

## Copyright and license
Code Copyright 2024 Materialize. Code released under the MIT license.
