"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeOrientedBoundingBoxFromPoints = makeOrientedBoundingBoxFromPoints;
exports.makeAxisAlignedBoundingBoxFromPoints = makeAxisAlignedBoundingBoxFromPoints;

var _core = require("@math.gl/core");

var _computeEigenDecomposition = _interopRequireDefault(require("./compute-eigen-decomposition"));

var _orientedBoundingBox = _interopRequireDefault(require("../bounding-volumes/oriented-bounding-box"));

var _axisAlignedBoundingBox = _interopRequireDefault(require("../bounding-volumes/axis-aligned-bounding-box"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var scratchVector2 = new _core.Vector3();
var scratchVector3 = new _core.Vector3();
var scratchVector4 = new _core.Vector3();
var scratchVector5 = new _core.Vector3();
var scratchVector6 = new _core.Vector3();
var scratchCovarianceResult = new _core.Matrix3();
var scratchEigenResult = {
  diagonal: new _core.Matrix3(),
  unitary: new _core.Matrix3()
};

function makeOrientedBoundingBoxFromPoints(positions) {
  var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _orientedBoundingBox.default();

  if (!positions || positions.length === 0) {
    result.halfAxes = new _core.Matrix3([0, 0, 0, 0, 0, 0, 0, 0, 0]);
    result.center = new _core.Vector3();
    return result;
  }

  var length = positions.length;
  var meanPoint = new _core.Vector3(0, 0, 0);

  var _iterator = _createForOfIteratorHelper(positions),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var position = _step.value;
      meanPoint.add(position);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var invLength = 1.0 / length;
  meanPoint.multiplyByScalar(invLength);
  var exx = 0.0;
  var exy = 0.0;
  var exz = 0.0;
  var eyy = 0.0;
  var eyz = 0.0;
  var ezz = 0.0;

  var _iterator2 = _createForOfIteratorHelper(positions),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var _position = _step2.value;
      var p = scratchVector2.copy(_position).subtract(meanPoint);
      exx += p.x * p.x;
      exy += p.x * p.y;
      exz += p.x * p.z;
      eyy += p.y * p.y;
      eyz += p.y * p.z;
      ezz += p.z * p.z;
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  exx *= invLength;
  exy *= invLength;
  exz *= invLength;
  eyy *= invLength;
  eyz *= invLength;
  ezz *= invLength;
  var covarianceMatrix = scratchCovarianceResult;
  covarianceMatrix[0] = exx;
  covarianceMatrix[1] = exy;
  covarianceMatrix[2] = exz;
  covarianceMatrix[3] = exy;
  covarianceMatrix[4] = eyy;
  covarianceMatrix[5] = eyz;
  covarianceMatrix[6] = exz;
  covarianceMatrix[7] = eyz;
  covarianceMatrix[8] = ezz;

  var _computeEigenDecompos = (0, _computeEigenDecomposition.default)(covarianceMatrix, scratchEigenResult),
      unitary = _computeEigenDecompos.unitary;

  var rotation = result.halfAxes.copy(unitary);
  var v1 = rotation.getColumn(0, scratchVector4);
  var v2 = rotation.getColumn(1, scratchVector5);
  var v3 = rotation.getColumn(2, scratchVector6);
  var u1 = -Number.MAX_VALUE;
  var u2 = -Number.MAX_VALUE;
  var u3 = -Number.MAX_VALUE;
  var l1 = Number.MAX_VALUE;
  var l2 = Number.MAX_VALUE;
  var l3 = Number.MAX_VALUE;

  var _iterator3 = _createForOfIteratorHelper(positions),
      _step3;

  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var _position2 = _step3.value;
      scratchVector2.copy(_position2);
      u1 = Math.max(scratchVector2.dot(v1), u1);
      u2 = Math.max(scratchVector2.dot(v2), u2);
      u3 = Math.max(scratchVector2.dot(v3), u3);
      l1 = Math.min(scratchVector2.dot(v1), l1);
      l2 = Math.min(scratchVector2.dot(v2), l2);
      l3 = Math.min(scratchVector2.dot(v3), l3);
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }

  v1 = v1.multiplyByScalar(0.5 * (l1 + u1));
  v2 = v2.multiplyByScalar(0.5 * (l2 + u2));
  v3 = v3.multiplyByScalar(0.5 * (l3 + u3));
  result.center.copy(v1).add(v2).add(v3);
  var scale = scratchVector3.set(u1 - l1, u2 - l2, u3 - l3).multiplyByScalar(0.5);
  var scaleMatrix = new _core.Matrix3([scale[0], 0, 0, 0, scale[1], 0, 0, 0, scale[2]]);
  result.halfAxes.multiplyRight(scaleMatrix);
  return result;
}

function makeAxisAlignedBoundingBoxFromPoints(positions) {
  var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _axisAlignedBoundingBox.default();

  if (!positions || positions.length === 0) {
    result.minimum.set(0, 0, 0);
    result.maximum.set(0, 0, 0);
    result.center.set(0, 0, 0);
    result.halfDiagonal.set(0, 0, 0);
    return result;
  }

  var minimumX = positions[0][0];
  var minimumY = positions[0][1];
  var minimumZ = positions[0][2];
  var maximumX = positions[0][0];
  var maximumY = positions[0][1];
  var maximumZ = positions[0][2];

  var _iterator4 = _createForOfIteratorHelper(positions),
      _step4;

  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var p = _step4.value;
      var x = p[0];
      var y = p[1];
      var z = p[2];
      minimumX = Math.min(x, minimumX);
      maximumX = Math.max(x, maximumX);
      minimumY = Math.min(y, minimumY);
      maximumY = Math.max(y, maximumY);
      minimumZ = Math.min(z, minimumZ);
      maximumZ = Math.max(z, maximumZ);
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }

  result.minimum.set(minimumX, minimumY, minimumZ);
  result.maximum.set(maximumX, maximumY, maximumZ);
  result.center.copy(result.minimum).add(result.maximum).scale(0.5);
  result.halfDiagonal.copy(result.maximum).subtract(result.center);
  return result;
}
//# sourceMappingURL=bounding-box-from-points.js.map