"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = makeBoundingSphereFromPoints;

var _core = require("@math.gl/core");

var _boundingSphere = _interopRequireDefault(require("../bounding-volumes/bounding-sphere"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var fromPointsXMin = new _core.Vector3();
var fromPointsYMin = new _core.Vector3();
var fromPointsZMin = new _core.Vector3();
var fromPointsXMax = new _core.Vector3();
var fromPointsYMax = new _core.Vector3();
var fromPointsZMax = new _core.Vector3();
var fromPointsCurrentPos = new _core.Vector3();
var fromPointsScratch = new _core.Vector3();
var fromPointsRitterCenter = new _core.Vector3();
var fromPointsMinBoxPt = new _core.Vector3();
var fromPointsMaxBoxPt = new _core.Vector3();
var fromPointsNaiveCenterScratch = new _core.Vector3();
var volumeConstant = 4.0 / 3.0 * Math.PI;

function makeBoundingSphereFromPoints(positions) {
  var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _boundingSphere.default();

  if (!positions || positions.length === 0) {
    return result.fromCenterRadius([0, 0, 0], 0);
  }

  var currentPos = fromPointsCurrentPos.copy(positions[0]);
  var xMin = fromPointsXMin.copy(currentPos);
  var yMin = fromPointsYMin.copy(currentPos);
  var zMin = fromPointsZMin.copy(currentPos);
  var xMax = fromPointsXMax.copy(currentPos);
  var yMax = fromPointsYMax.copy(currentPos);
  var zMax = fromPointsZMax.copy(currentPos);

  var _iterator = _createForOfIteratorHelper(positions),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var position = _step.value;
      currentPos.copy(position);
      var x = currentPos.x;
      var y = currentPos.y;
      var z = currentPos.z;

      if (x < xMin.x) {
        xMin.copy(currentPos);
      }

      if (x > xMax.x) {
        xMax.copy(currentPos);
      }

      if (y < yMin.y) {
        yMin.copy(currentPos);
      }

      if (y > yMax.y) {
        yMax.copy(currentPos);
      }

      if (z < zMin.z) {
        zMin.copy(currentPos);
      }

      if (z > zMax.z) {
        zMax.copy(currentPos);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var xSpan = fromPointsScratch.copy(xMax).subtract(xMin).magnitudeSquared();
  var ySpan = fromPointsScratch.copy(yMax).subtract(yMin).magnitudeSquared();
  var zSpan = fromPointsScratch.copy(zMax).subtract(zMin).magnitudeSquared();
  var diameter1 = xMin;
  var diameter2 = xMax;
  var maxSpan = xSpan;

  if (ySpan > maxSpan) {
    maxSpan = ySpan;
    diameter1 = yMin;
    diameter2 = yMax;
  }

  if (zSpan > maxSpan) {
    maxSpan = zSpan;
    diameter1 = zMin;
    diameter2 = zMax;
  }

  var ritterCenter = fromPointsRitterCenter;
  ritterCenter.x = (diameter1.x + diameter2.x) * 0.5;
  ritterCenter.y = (diameter1.y + diameter2.y) * 0.5;
  ritterCenter.z = (diameter1.z + diameter2.z) * 0.5;
  var radiusSquared = fromPointsScratch.copy(diameter2).subtract(ritterCenter).magnitudeSquared();
  var ritterRadius = Math.sqrt(radiusSquared);
  var minBoxPt = fromPointsMinBoxPt;
  minBoxPt.x = xMin.x;
  minBoxPt.y = yMin.y;
  minBoxPt.z = zMin.z;
  var maxBoxPt = fromPointsMaxBoxPt;
  maxBoxPt.x = xMax.x;
  maxBoxPt.y = yMax.y;
  maxBoxPt.z = zMax.z;
  var naiveCenter = fromPointsNaiveCenterScratch.copy(minBoxPt).add(maxBoxPt).multiplyByScalar(0.5);
  var naiveRadius = 0;

  var _iterator2 = _createForOfIteratorHelper(positions),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var _position = _step2.value;
      currentPos.copy(_position);
      var r = fromPointsScratch.copy(currentPos).subtract(naiveCenter).magnitude();

      if (r > naiveRadius) {
        naiveRadius = r;
      }

      var oldCenterToPointSquared = fromPointsScratch.copy(currentPos).subtract(ritterCenter).magnitudeSquared();

      if (oldCenterToPointSquared > radiusSquared) {
        var oldCenterToPoint = Math.sqrt(oldCenterToPointSquared);
        ritterRadius = (ritterRadius + oldCenterToPoint) * 0.5;
        radiusSquared = ritterRadius * ritterRadius;
        var oldToNew = oldCenterToPoint - ritterRadius;
        ritterCenter.x = (ritterRadius * ritterCenter.x + oldToNew * currentPos.x) / oldCenterToPoint;
        ritterCenter.y = (ritterRadius * ritterCenter.y + oldToNew * currentPos.y) / oldCenterToPoint;
        ritterCenter.z = (ritterRadius * ritterCenter.z + oldToNew * currentPos.z) / oldCenterToPoint;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  if (ritterRadius < naiveRadius) {
    ritterCenter.to(result.center);
    result.radius = ritterRadius;
  } else {
    naiveCenter.to(result.center);
    result.radius = naiveRadius;
  }

  return result;
}
//# sourceMappingURL=bounding-sphere-from-points.js.map