"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _constants = require("../../constants");

var scratchVector = new _core.Vector3();
var scratchNormal = new _core.Vector3();

var AxisAlignedBoundingBox = function () {
  function AxisAlignedBoundingBox() {
    var minimum = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0, 0];
    var maximum = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
    var center = arguments.length > 2 ? arguments[2] : undefined;
    (0, _classCallCheck2.default)(this, AxisAlignedBoundingBox);
    (0, _defineProperty2.default)(this, "center", void 0);
    (0, _defineProperty2.default)(this, "halfDiagonal", void 0);
    (0, _defineProperty2.default)(this, "minimum", void 0);
    (0, _defineProperty2.default)(this, "maximum", void 0);
    center = center || scratchVector.copy(minimum).add(maximum).scale(0.5);
    this.center = new _core.Vector3(center);
    this.halfDiagonal = new _core.Vector3(maximum).subtract(this.center);
    this.minimum = new _core.Vector3(minimum);
    this.maximum = new _core.Vector3(maximum);
  }

  (0, _createClass2.default)(AxisAlignedBoundingBox, [{
    key: "clone",
    value: function clone() {
      return new AxisAlignedBoundingBox(this.minimum, this.maximum, this.center);
    }
  }, {
    key: "equals",
    value: function equals(right) {
      return this === right || Boolean(right) && this.minimum.equals(right.minimum) && this.maximum.equals(right.maximum);
    }
  }, {
    key: "transform",
    value: function transform(_transform) {
      this.center.transformAsPoint(_transform);
      this.halfDiagonal.transform(_transform);
      this.minimum.transform(_transform);
      this.maximum.transform(_transform);
      return this;
    }
  }, {
    key: "intersectPlane",
    value: function intersectPlane(plane) {
      var halfDiagonal = this.halfDiagonal;
      var normal = scratchNormal.from(plane.normal);
      var e = halfDiagonal.x * Math.abs(normal.x) + halfDiagonal.y * Math.abs(normal.y) + halfDiagonal.z * Math.abs(normal.z);
      var s = this.center.dot(normal) + plane.distance;

      if (s - e > 0) {
        return _constants.INTERSECTION.INSIDE;
      }

      if (s + e < 0) {
        return _constants.INTERSECTION.OUTSIDE;
      }

      return _constants.INTERSECTION.INTERSECTING;
    }
  }, {
    key: "distanceTo",
    value: function distanceTo(point) {
      return Math.sqrt(this.distanceSquaredTo(point));
    }
  }, {
    key: "distanceSquaredTo",
    value: function distanceSquaredTo(point) {
      var offset = scratchVector.from(point).subtract(this.center);
      var halfDiagonal = this.halfDiagonal;
      var distanceSquared = 0.0;
      var d;
      d = Math.abs(offset.x) - halfDiagonal.x;

      if (d > 0) {
        distanceSquared += d * d;
      }

      d = Math.abs(offset.y) - halfDiagonal.y;

      if (d > 0) {
        distanceSquared += d * d;
      }

      d = Math.abs(offset.z) - halfDiagonal.z;

      if (d > 0) {
        distanceSquared += d * d;
      }

      return distanceSquared;
    }
  }]);
  return AxisAlignedBoundingBox;
}();

exports.default = AxisAlignedBoundingBox;
//# sourceMappingURL=axis-aligned-bounding-box.js.map