"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var mat4 = _interopRequireWildcard(require("gl-matrix/mat4"));

var _constants = require("../../constants");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var scratchVector = new _core.Vector3();
var scratchVector2 = new _core.Vector3();

var BoundingSphere = function () {
  function BoundingSphere() {
    var center = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0, 0];
    var radius = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.0;
    (0, _classCallCheck2.default)(this, BoundingSphere);
    (0, _defineProperty2.default)(this, "center", void 0);
    (0, _defineProperty2.default)(this, "radius", void 0);
    this.radius = -0;
    this.center = new _core.Vector3();
    this.fromCenterRadius(center, radius);
  }

  (0, _createClass2.default)(BoundingSphere, [{
    key: "fromCenterRadius",
    value: function fromCenterRadius(center, radius) {
      this.center.from(center);
      this.radius = radius;
      return this;
    }
  }, {
    key: "fromCornerPoints",
    value: function fromCornerPoints(corner, oppositeCorner) {
      oppositeCorner = scratchVector.from(oppositeCorner);
      this.center = new _core.Vector3().from(corner).add(oppositeCorner).scale(0.5);
      this.radius = this.center.distance(oppositeCorner);
      return this;
    }
  }, {
    key: "equals",
    value: function equals(right) {
      return this === right || Boolean(right) && this.center.equals(right.center) && this.radius === right.radius;
    }
  }, {
    key: "clone",
    value: function clone() {
      return new BoundingSphere(this.center, this.radius);
    }
  }, {
    key: "union",
    value: function union(boundingSphere) {
      var leftCenter = this.center;
      var leftRadius = this.radius;
      var rightCenter = boundingSphere.center;
      var rightRadius = boundingSphere.radius;
      var toRightCenter = scratchVector.copy(rightCenter).subtract(leftCenter);
      var centerSeparation = toRightCenter.magnitude();

      if (leftRadius >= centerSeparation + rightRadius) {
        return this.clone();
      }

      if (rightRadius >= centerSeparation + leftRadius) {
        return boundingSphere.clone();
      }

      var halfDistanceBetweenTangentPoints = (leftRadius + centerSeparation + rightRadius) * 0.5;
      scratchVector2.copy(toRightCenter).scale((-leftRadius + halfDistanceBetweenTangentPoints) / centerSeparation).add(leftCenter);
      this.center.copy(scratchVector2);
      this.radius = halfDistanceBetweenTangentPoints;
      return this;
    }
  }, {
    key: "expand",
    value: function expand(point) {
      var scratchPoint = scratchVector.from(point);
      var radius = scratchPoint.subtract(this.center).magnitude();

      if (radius > this.radius) {
        this.radius = radius;
      }

      return this;
    }
  }, {
    key: "transform",
    value: function transform(_transform) {
      this.center.transform(_transform);
      var scale = mat4.getScaling(scratchVector, _transform);
      this.radius = Math.max(scale[0], Math.max(scale[1], scale[2])) * this.radius;
      return this;
    }
  }, {
    key: "distanceSquaredTo",
    value: function distanceSquaredTo(point) {
      var d = this.distanceTo(point);
      return d * d;
    }
  }, {
    key: "distanceTo",
    value: function distanceTo(point) {
      var scratchPoint = scratchVector.from(point);
      var delta = scratchPoint.subtract(this.center);
      return Math.max(0, delta.len() - this.radius);
    }
  }, {
    key: "intersectPlane",
    value: function intersectPlane(plane) {
      var center = this.center;
      var radius = this.radius;
      var normal = plane.normal;
      var distanceToPlane = normal.dot(center) + plane.distance;

      if (distanceToPlane < -radius) {
        return _constants.INTERSECTION.OUTSIDE;
      }

      if (distanceToPlane < radius) {
        return _constants.INTERSECTION.INTERSECTING;
      }

      return _constants.INTERSECTION.INSIDE;
    }
  }]);
  return BoundingSphere;
}();

exports.default = BoundingSphere;
//# sourceMappingURL=bounding-sphere.js.map