"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _boundingSphere = _interopRequireDefault(require("./bounding-sphere"));

var _constants = require("../../constants");

var scratchVector3 = new _core.Vector3();
var scratchOffset = new _core.Vector3();
var scratchVectorU = new _core.Vector3();
var scratchVectorV = new _core.Vector3();
var scratchVectorW = new _core.Vector3();
var scratchCorner = new _core.Vector3();
var scratchToCenter = new _core.Vector3();
var MATRIX3 = {
  COLUMN0ROW0: 0,
  COLUMN0ROW1: 1,
  COLUMN0ROW2: 2,
  COLUMN1ROW0: 3,
  COLUMN1ROW1: 4,
  COLUMN1ROW2: 5,
  COLUMN2ROW0: 6,
  COLUMN2ROW1: 7,
  COLUMN2ROW2: 8
};

var OrientedBoundingBox = function () {
  function OrientedBoundingBox() {
    var center = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0, 0];
    var halfAxes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0, 0, 0, 0, 0, 0, 0];
    (0, _classCallCheck2.default)(this, OrientedBoundingBox);
    (0, _defineProperty2.default)(this, "center", void 0);
    (0, _defineProperty2.default)(this, "halfAxes", void 0);
    this.center = new _core.Vector3().from(center);
    this.halfAxes = new _core.Matrix3(halfAxes);
  }

  (0, _createClass2.default)(OrientedBoundingBox, [{
    key: "halfSize",
    get: function get() {
      var xAxis = this.halfAxes.getColumn(0);
      var yAxis = this.halfAxes.getColumn(1);
      var zAxis = this.halfAxes.getColumn(2);
      return [new _core.Vector3(xAxis).len(), new _core.Vector3(yAxis).len(), new _core.Vector3(zAxis).len()];
    }
  }, {
    key: "quaternion",
    get: function get() {
      var xAxis = this.halfAxes.getColumn(0);
      var yAxis = this.halfAxes.getColumn(1);
      var zAxis = this.halfAxes.getColumn(2);
      var normXAxis = new _core.Vector3(xAxis).normalize();
      var normYAxis = new _core.Vector3(yAxis).normalize();
      var normZAxis = new _core.Vector3(zAxis).normalize();
      return new _core.Quaternion().fromMatrix3(new _core.Matrix3([].concat((0, _toConsumableArray2.default)(normXAxis), (0, _toConsumableArray2.default)(normYAxis), (0, _toConsumableArray2.default)(normZAxis))));
    }
  }, {
    key: "fromCenterHalfSizeQuaternion",
    value: function fromCenterHalfSizeQuaternion(center, halfSize, quaternion) {
      var quaternionObject = new _core.Quaternion(quaternion);
      var directionsMatrix = new _core.Matrix3().fromQuaternion(quaternionObject);
      directionsMatrix[0] = directionsMatrix[0] * halfSize[0];
      directionsMatrix[1] = directionsMatrix[1] * halfSize[0];
      directionsMatrix[2] = directionsMatrix[2] * halfSize[0];
      directionsMatrix[3] = directionsMatrix[3] * halfSize[1];
      directionsMatrix[4] = directionsMatrix[4] * halfSize[1];
      directionsMatrix[5] = directionsMatrix[5] * halfSize[1];
      directionsMatrix[6] = directionsMatrix[6] * halfSize[2];
      directionsMatrix[7] = directionsMatrix[7] * halfSize[2];
      directionsMatrix[8] = directionsMatrix[8] * halfSize[2];
      this.center = new _core.Vector3().from(center);
      this.halfAxes = directionsMatrix;
      return this;
    }
  }, {
    key: "clone",
    value: function clone() {
      return new OrientedBoundingBox(this.center, this.halfAxes);
    }
  }, {
    key: "equals",
    value: function equals(right) {
      return this === right || Boolean(right) && this.center.equals(right.center) && this.halfAxes.equals(right.halfAxes);
    }
  }, {
    key: "getBoundingSphere",
    value: function getBoundingSphere() {
      var result = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new _boundingSphere.default();
      var halfAxes = this.halfAxes;
      var u = halfAxes.getColumn(0, scratchVectorU);
      var v = halfAxes.getColumn(1, scratchVectorV);
      var w = halfAxes.getColumn(2, scratchVectorW);
      var cornerVector = scratchVector3.copy(u).add(v).add(w);
      result.center.copy(this.center);
      result.radius = cornerVector.magnitude();
      return result;
    }
  }, {
    key: "intersectPlane",
    value: function intersectPlane(plane) {
      var center = this.center;
      var normal = plane.normal;
      var halfAxes = this.halfAxes;
      var normalX = normal.x;
      var normalY = normal.y;
      var normalZ = normal.z;
      var radEffective = Math.abs(normalX * halfAxes[MATRIX3.COLUMN0ROW0] + normalY * halfAxes[MATRIX3.COLUMN0ROW1] + normalZ * halfAxes[MATRIX3.COLUMN0ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN1ROW0] + normalY * halfAxes[MATRIX3.COLUMN1ROW1] + normalZ * halfAxes[MATRIX3.COLUMN1ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN2ROW0] + normalY * halfAxes[MATRIX3.COLUMN2ROW1] + normalZ * halfAxes[MATRIX3.COLUMN2ROW2]);
      var distanceToPlane = normal.dot(center) + plane.distance;

      if (distanceToPlane <= -radEffective) {
        return _constants.INTERSECTION.OUTSIDE;
      } else if (distanceToPlane >= radEffective) {
        return _constants.INTERSECTION.INSIDE;
      }

      return _constants.INTERSECTION.INTERSECTING;
    }
  }, {
    key: "distanceTo",
    value: function distanceTo(point) {
      return Math.sqrt(this.distanceSquaredTo(point));
    }
  }, {
    key: "distanceSquaredTo",
    value: function distanceSquaredTo(point) {
      var offset = scratchOffset.from(point).subtract(this.center);
      var halfAxes = this.halfAxes;
      var u = halfAxes.getColumn(0, scratchVectorU);
      var v = halfAxes.getColumn(1, scratchVectorV);
      var w = halfAxes.getColumn(2, scratchVectorW);
      var uHalf = u.magnitude();
      var vHalf = v.magnitude();
      var wHalf = w.magnitude();
      u.normalize();
      v.normalize();
      w.normalize();
      var distanceSquared = 0.0;
      var d;
      d = Math.abs(offset.dot(u)) - uHalf;

      if (d > 0) {
        distanceSquared += d * d;
      }

      d = Math.abs(offset.dot(v)) - vHalf;

      if (d > 0) {
        distanceSquared += d * d;
      }

      d = Math.abs(offset.dot(w)) - wHalf;

      if (d > 0) {
        distanceSquared += d * d;
      }

      return distanceSquared;
    }
  }, {
    key: "computePlaneDistances",
    value: function computePlaneDistances(position, direction) {
      var result = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [-0, -0];
      var minDist = Number.POSITIVE_INFINITY;
      var maxDist = Number.NEGATIVE_INFINITY;
      var center = this.center;
      var halfAxes = this.halfAxes;
      var u = halfAxes.getColumn(0, scratchVectorU);
      var v = halfAxes.getColumn(1, scratchVectorV);
      var w = halfAxes.getColumn(2, scratchVectorW);
      var corner = scratchCorner.copy(u).add(v).add(w).add(center);
      var toCenter = scratchToCenter.copy(corner).subtract(position);
      var mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      corner.copy(center).add(u).add(v).subtract(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      corner.copy(center).add(u).subtract(v).add(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      corner.copy(center).add(u).subtract(v).subtract(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      center.copy(corner).subtract(u).add(v).add(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      center.copy(corner).subtract(u).add(v).subtract(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      center.copy(corner).subtract(u).subtract(v).add(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      center.copy(corner).subtract(u).subtract(v).subtract(w);
      toCenter.copy(corner).subtract(position);
      mag = direction.dot(toCenter);
      minDist = Math.min(mag, minDist);
      maxDist = Math.max(mag, maxDist);
      result[0] = minDist;
      result[1] = maxDist;
      return result;
    }
  }, {
    key: "transform",
    value: function transform(transformation) {
      this.center.transformAsPoint(transformation);
      var xAxis = this.halfAxes.getColumn(0, scratchVectorU);
      xAxis.transformAsPoint(transformation);
      var yAxis = this.halfAxes.getColumn(1, scratchVectorV);
      yAxis.transformAsPoint(transformation);
      var zAxis = this.halfAxes.getColumn(2, scratchVectorW);
      zAxis.transformAsPoint(transformation);
      this.halfAxes = new _core.Matrix3([].concat((0, _toConsumableArray2.default)(xAxis), (0, _toConsumableArray2.default)(yAxis), (0, _toConsumableArray2.default)(zAxis)));
      return this;
    }
  }, {
    key: "getTransform",
    value: function getTransform() {
      throw new Error('not implemented');
    }
  }]);
  return OrientedBoundingBox;
}();

exports.default = OrientedBoundingBox;
//# sourceMappingURL=oriented-bounding-box.js.map