"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _constants = require("../constants");

var _plane = _interopRequireDefault(require("./plane"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var faces = [new _core.Vector3([1, 0, 0]), new _core.Vector3([0, 1, 0]), new _core.Vector3([0, 0, 1])];
var scratchPlaneCenter = new _core.Vector3();
var scratchPlaneNormal = new _core.Vector3();
var scratchPlane = new _plane.default(new _core.Vector3(1.0, 0.0, 0.0), 0.0);

var CullingVolume = function () {
  function CullingVolume() {
    var planes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    (0, _classCallCheck2.default)(this, CullingVolume);
    (0, _defineProperty2.default)(this, "planes", void 0);
    this.planes = planes;
  }

  (0, _createClass2.default)(CullingVolume, [{
    key: "fromBoundingSphere",
    value: function fromBoundingSphere(boundingSphere) {
      this.planes.length = 2 * faces.length;
      var center = boundingSphere.center;
      var radius = boundingSphere.radius;
      var planeIndex = 0;

      var _iterator = _createForOfIteratorHelper(faces),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var faceNormal = _step.value;
          var plane0 = this.planes[planeIndex];
          var plane1 = this.planes[planeIndex + 1];

          if (!plane0) {
            plane0 = this.planes[planeIndex] = new _plane.default();
          }

          if (!plane1) {
            plane1 = this.planes[planeIndex + 1] = new _plane.default();
          }

          var plane0Center = scratchPlaneCenter.copy(faceNormal).scale(-radius).add(center);
          var plane0Distance = -faceNormal.dot(plane0Center);
          plane0.fromPointNormal(plane0Center, faceNormal);
          var plane1Center = scratchPlaneCenter.copy(faceNormal).scale(radius).add(center);
          var negatedFaceNormal = scratchPlaneNormal.copy(faceNormal).negate();
          var plane1Distance = -negatedFaceNormal.dot(plane1Center);
          plane1.fromPointNormal(plane1Center, negatedFaceNormal);
          planeIndex += 2;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return this;
    }
  }, {
    key: "computeVisibility",
    value: function computeVisibility(boundingVolume) {
      var intersect = _constants.INTERSECTION.INSIDE;

      var _iterator2 = _createForOfIteratorHelper(this.planes),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var plane = _step2.value;
          var result = boundingVolume.intersectPlane(plane);

          switch (result) {
            case _constants.INTERSECTION.OUTSIDE:
              return _constants.INTERSECTION.OUTSIDE;

            case _constants.INTERSECTION.INTERSECTING:
              intersect = _constants.INTERSECTION.INTERSECTING;
              break;

            default:
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return intersect;
    }
  }, {
    key: "computeVisibilityWithPlaneMask",
    value: function computeVisibilityWithPlaneMask(boundingVolume, parentPlaneMask) {
      (0, _core.assert)(Number.isFinite(parentPlaneMask), 'parentPlaneMask is required.');

      if (parentPlaneMask === CullingVolume.MASK_OUTSIDE || parentPlaneMask === CullingVolume.MASK_INSIDE) {
        return parentPlaneMask;
      }

      var mask = CullingVolume.MASK_INSIDE;
      var planes = this.planes;

      for (var k = 0; k < this.planes.length; ++k) {
        var flag = k < 31 ? 1 << k : 0;

        if (k < 31 && (parentPlaneMask & flag) === 0) {
          continue;
        }

        var plane = planes[k];
        var result = boundingVolume.intersectPlane(plane);

        if (result === _constants.INTERSECTION.OUTSIDE) {
          return CullingVolume.MASK_OUTSIDE;
        } else if (result === _constants.INTERSECTION.INTERSECTING) {
          mask |= flag;
        }
      }

      return mask;
    }
  }]);
  return CullingVolume;
}();

exports.default = CullingVolume;
(0, _defineProperty2.default)(CullingVolume, "MASK_OUTSIDE", 0xffffffff);
(0, _defineProperty2.default)(CullingVolume, "MASK_INSIDE", 0x00000000);
(0, _defineProperty2.default)(CullingVolume, "MASK_INDETERMINATE", 0x7fffffff);
//# sourceMappingURL=culling-volume.js.map