"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _perspectiveOffCenterFrustum = _interopRequireDefault(require("./perspective-off-center-frustum"));

var defined = function defined(val) {
  return val !== null && typeof val !== 'undefined';
};

var PerspectiveFrustum = function () {
  function PerspectiveFrustum() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2.default)(this, PerspectiveFrustum);
    (0, _defineProperty2.default)(this, "_offCenterFrustum", new _perspectiveOffCenterFrustum.default());
    (0, _defineProperty2.default)(this, "fov", void 0);
    (0, _defineProperty2.default)(this, "_fov", void 0);
    (0, _defineProperty2.default)(this, "_fovy", void 0);
    (0, _defineProperty2.default)(this, "_sseDenominator", void 0);
    (0, _defineProperty2.default)(this, "aspectRatio", void 0);
    (0, _defineProperty2.default)(this, "_aspectRatio", void 0);
    (0, _defineProperty2.default)(this, "near", void 0);
    (0, _defineProperty2.default)(this, "_near", void 0);
    (0, _defineProperty2.default)(this, "far", void 0);
    (0, _defineProperty2.default)(this, "_far", void 0);
    (0, _defineProperty2.default)(this, "xOffset", void 0);
    (0, _defineProperty2.default)(this, "_xOffset", void 0);
    (0, _defineProperty2.default)(this, "yOffset", void 0);
    (0, _defineProperty2.default)(this, "_yOffset", void 0);
    var fov = options.fov,
        aspectRatio = options.aspectRatio,
        _options$near = options.near,
        near = _options$near === void 0 ? 1.0 : _options$near,
        _options$far = options.far,
        far = _options$far === void 0 ? 500000000.0 : _options$far,
        _options$xOffset = options.xOffset,
        xOffset = _options$xOffset === void 0 ? 0.0 : _options$xOffset,
        _options$yOffset = options.yOffset,
        yOffset = _options$yOffset === void 0 ? 0.0 : _options$yOffset;
    this.fov = fov;
    this.aspectRatio = aspectRatio;
    this.near = near;
    this.far = far;
    this.xOffset = xOffset;
    this.yOffset = yOffset;
  }

  (0, _createClass2.default)(PerspectiveFrustum, [{
    key: "clone",
    value: function clone() {
      return new PerspectiveFrustum({
        aspectRatio: this.aspectRatio,
        fov: this.fov,
        near: this.near,
        far: this.far
      });
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (!defined(other) || !(other instanceof PerspectiveFrustum)) {
        return false;
      }

      this._update();

      other._update();

      return this.fov === other.fov && this.aspectRatio === other.aspectRatio && this.near === other.near && this.far === other.far && this._offCenterFrustum.equals(other._offCenterFrustum);
    }
  }, {
    key: "projectionMatrix",
    get: function get() {
      this._update();

      return this._offCenterFrustum.projectionMatrix;
    }
  }, {
    key: "infiniteProjectionMatrix",
    get: function get() {
      this._update();

      return this._offCenterFrustum.infiniteProjectionMatrix;
    }
  }, {
    key: "fovy",
    get: function get() {
      this._update();

      return this._fovy;
    }
  }, {
    key: "sseDenominator",
    get: function get() {
      this._update();

      return this._sseDenominator;
    }
  }, {
    key: "computeCullingVolume",
    value: function computeCullingVolume(position, direction, up) {
      this._update();

      return this._offCenterFrustum.computeCullingVolume(position, direction, up);
    }
  }, {
    key: "getPixelDimensions",
    value: function getPixelDimensions(drawingBufferWidth, drawingBufferHeight, distance, result) {
      this._update();

      return this._offCenterFrustum.getPixelDimensions(drawingBufferWidth, drawingBufferHeight, distance, result || new _core.Vector2());
    }
  }, {
    key: "_update",
    value: function _update() {
      (0, _core.assert)(Number.isFinite(this.fov) && Number.isFinite(this.aspectRatio) && Number.isFinite(this.near) && Number.isFinite(this.far));
      var f = this._offCenterFrustum;

      if (this.fov !== this._fov || this.aspectRatio !== this._aspectRatio || this.near !== this._near || this.far !== this._far || this.xOffset !== this._xOffset || this.yOffset !== this._yOffset) {
        (0, _core.assert)(this.fov >= 0 && this.fov < Math.PI);
        (0, _core.assert)(this.aspectRatio > 0);
        (0, _core.assert)(this.near >= 0 && this.near < this.far);
        this._aspectRatio = this.aspectRatio;
        this._fov = this.fov;
        this._fovy = this.aspectRatio <= 1 ? this.fov : Math.atan(Math.tan(this.fov * 0.5) / this.aspectRatio) * 2.0;
        this._near = this.near;
        this._far = this.far;
        this._sseDenominator = 2.0 * Math.tan(0.5 * this._fovy);
        this._xOffset = this.xOffset;
        this._yOffset = this.yOffset;
        f.top = this.near * Math.tan(0.5 * this._fovy);
        f.bottom = -f.top;
        f.right = this.aspectRatio * f.top;
        f.left = -f.right;
        f.near = this.near;
        f.far = this.far;
        f.right += this.xOffset;
        f.left += this.xOffset;
        f.top += this.yOffset;
        f.bottom += this.yOffset;
      }
    }
  }]);
  return PerspectiveFrustum;
}();

exports.default = PerspectiveFrustum;
//# sourceMappingURL=perspective-frustum.js.map