"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _cullingVolume = _interopRequireDefault(require("./culling-volume"));

var _plane = _interopRequireDefault(require("./plane"));

var scratchPlaneUpVector = new _core.Vector3();
var scratchPlaneRightVector = new _core.Vector3();
var scratchPlaneNearCenter = new _core.Vector3();
var scratchPlaneFarCenter = new _core.Vector3();
var scratchPlaneNormal = new _core.Vector3();

var PerspectiveOffCenterFrustum = function () {
  function PerspectiveOffCenterFrustum() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2.default)(this, PerspectiveOffCenterFrustum);
    (0, _defineProperty2.default)(this, "left", void 0);
    (0, _defineProperty2.default)(this, "_left", void 0);
    (0, _defineProperty2.default)(this, "right", void 0);
    (0, _defineProperty2.default)(this, "_right", void 0);
    (0, _defineProperty2.default)(this, "top", void 0);
    (0, _defineProperty2.default)(this, "_top", void 0);
    (0, _defineProperty2.default)(this, "bottom", void 0);
    (0, _defineProperty2.default)(this, "_bottom", void 0);
    (0, _defineProperty2.default)(this, "near", void 0);
    (0, _defineProperty2.default)(this, "_near", void 0);
    (0, _defineProperty2.default)(this, "far", void 0);
    (0, _defineProperty2.default)(this, "_far", void 0);
    (0, _defineProperty2.default)(this, "_cullingVolume", new _cullingVolume.default([new _plane.default(), new _plane.default(), new _plane.default(), new _plane.default(), new _plane.default(), new _plane.default()]));
    (0, _defineProperty2.default)(this, "_perspectiveMatrix", new _core.Matrix4());
    (0, _defineProperty2.default)(this, "_infinitePerspective", new _core.Matrix4());
    var _options$near = options.near,
        near = _options$near === void 0 ? 1.0 : _options$near,
        _options$far = options.far,
        far = _options$far === void 0 ? 500000000.0 : _options$far;
    this.left = options.left;
    this._left = undefined;
    this.right = options.right;
    this._right = undefined;
    this.top = options.top;
    this._top = undefined;
    this.bottom = options.bottom;
    this._bottom = undefined;
    this.near = near;
    this._near = near;
    this.far = far;
    this._far = far;
  }

  (0, _createClass2.default)(PerspectiveOffCenterFrustum, [{
    key: "clone",
    value: function clone() {
      return new PerspectiveOffCenterFrustum({
        right: this.right,
        left: this.left,
        top: this.top,
        bottom: this.bottom,
        near: this.near,
        far: this.far
      });
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return other && other instanceof PerspectiveOffCenterFrustum && this.right === other.right && this.left === other.left && this.top === other.top && this.bottom === other.bottom && this.near === other.near && this.far === other.far;
    }
  }, {
    key: "projectionMatrix",
    get: function get() {
      this._update();

      return this._perspectiveMatrix;
    }
  }, {
    key: "infiniteProjectionMatrix",
    get: function get() {
      this._update();

      return this._infinitePerspective;
    }
  }, {
    key: "computeCullingVolume",
    value: function computeCullingVolume(position, direction, up) {
      (0, _core.assert)(position, 'position is required.');
      (0, _core.assert)(direction, 'direction is required.');
      (0, _core.assert)(up, 'up is required.');
      var planes = this._cullingVolume.planes;
      up = scratchPlaneUpVector.copy(up).normalize();
      var right = scratchPlaneRightVector.copy(direction).cross(up).normalize();
      var nearCenter = scratchPlaneNearCenter.copy(direction).multiplyByScalar(this.near).add(position);
      var farCenter = scratchPlaneFarCenter.copy(direction).multiplyByScalar(this.far).add(position);
      var normal = scratchPlaneNormal;
      normal.copy(right).multiplyByScalar(this.left).add(nearCenter).subtract(position).cross(up);
      planes[0].fromPointNormal(position, normal);
      normal.copy(right).multiplyByScalar(this.right).add(nearCenter).subtract(position).cross(up).negate();
      planes[1].fromPointNormal(position, normal);
      normal.copy(up).multiplyByScalar(this.bottom).add(nearCenter).subtract(position).cross(right).negate();
      planes[2].fromPointNormal(position, normal);
      normal.copy(up).multiplyByScalar(this.top).add(nearCenter).subtract(position).cross(right);
      planes[3].fromPointNormal(position, normal);
      normal = new _core.Vector3().copy(direction);
      planes[4].fromPointNormal(nearCenter, normal);
      normal.negate();
      planes[5].fromPointNormal(farCenter, normal);
      return this._cullingVolume;
    }
  }, {
    key: "getPixelDimensions",
    value: function getPixelDimensions(drawingBufferWidth, drawingBufferHeight, distance, result) {
      this._update();

      (0, _core.assert)(Number.isFinite(drawingBufferWidth) && Number.isFinite(drawingBufferHeight));
      (0, _core.assert)(drawingBufferWidth > 0);
      (0, _core.assert)(drawingBufferHeight > 0);
      (0, _core.assert)(distance > 0);
      (0, _core.assert)(result);
      var inverseNear = 1.0 / this.near;
      var tanTheta = this.top * inverseNear;
      var pixelHeight = 2.0 * distance * tanTheta / drawingBufferHeight;
      tanTheta = this.right * inverseNear;
      var pixelWidth = 2.0 * distance * tanTheta / drawingBufferWidth;
      result.x = pixelWidth;
      result.y = pixelHeight;
      return result;
    }
  }, {
    key: "_update",
    value: function _update() {
      (0, _core.assert)(Number.isFinite(this.right) && Number.isFinite(this.left) && Number.isFinite(this.top) && Number.isFinite(this.bottom) && Number.isFinite(this.near) && Number.isFinite(this.far));
      var top = this.top,
          bottom = this.bottom,
          right = this.right,
          left = this.left,
          near = this.near,
          far = this.far;

      if (top !== this._top || bottom !== this._bottom || left !== this._left || right !== this._right || near !== this._near || far !== this._far) {
        (0, _core.assert)(this.near > 0 && this.near < this.far, 'near must be greater than zero and less than far.');
        this._left = left;
        this._right = right;
        this._top = top;
        this._bottom = bottom;
        this._near = near;
        this._far = far;
        this._perspectiveMatrix = new _core.Matrix4().frustum({
          left: left,
          right: right,
          bottom: bottom,
          top: top,
          near: near,
          far: far
        });
        this._infinitePerspective = new _core.Matrix4().frustum({
          left: left,
          right: right,
          bottom: bottom,
          top: top,
          near: near,
          far: Infinity
        });
      }
    }
  }]);
  return PerspectiveOffCenterFrustum;
}();

exports.default = PerspectiveOffCenterFrustum;
//# sourceMappingURL=perspective-off-center-frustum.js.map