"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var scratchPosition = new _core.Vector3();
var scratchNormal = new _core.Vector3();

var Plane = function () {
  function Plane() {
    var normal = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0, 1];
    var distance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    (0, _classCallCheck2.default)(this, Plane);
    (0, _defineProperty2.default)(this, "normal", void 0);
    (0, _defineProperty2.default)(this, "distance", void 0);
    this.normal = new _core.Vector3();
    this.distance = -0;
    this.fromNormalDistance(normal, distance);
  }

  (0, _createClass2.default)(Plane, [{
    key: "fromNormalDistance",
    value: function fromNormalDistance(normal, distance) {
      (0, _core.assert)(Number.isFinite(distance));
      this.normal.from(normal).normalize();
      this.distance = distance;
      return this;
    }
  }, {
    key: "fromPointNormal",
    value: function fromPointNormal(point, normal) {
      point = scratchPosition.from(point);
      this.normal.from(normal).normalize();
      var distance = -this.normal.dot(point);
      this.distance = distance;
      return this;
    }
  }, {
    key: "fromCoefficients",
    value: function fromCoefficients(a, b, c, d) {
      this.normal.set(a, b, c);
      (0, _core.assert)((0, _core.equals)(this.normal.len(), 1));
      this.distance = d;
      return this;
    }
  }, {
    key: "clone",
    value: function clone() {
      return new Plane(this.normal, this.distance);
    }
  }, {
    key: "equals",
    value: function equals(right) {
      return (0, _core.equals)(this.distance, right.distance) && (0, _core.equals)(this.normal, right.normal);
    }
  }, {
    key: "getPointDistance",
    value: function getPointDistance(point) {
      return this.normal.dot(point) + this.distance;
    }
  }, {
    key: "transform",
    value: function transform(matrix4) {
      var normal = scratchNormal.copy(this.normal).transformAsVector(matrix4).normalize();
      var point = this.normal.scale(-this.distance).transform(matrix4);
      return this.fromPointNormal(point, normal);
    }
  }, {
    key: "projectPointOntoPlane",
    value: function projectPointOntoPlane(point) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      point = scratchPosition.from(point);
      var pointDistance = this.getPointDistance(point);
      var scaledNormal = scratchNormal.copy(this.normal).scale(pointDistance);
      return point.subtract(scaledNormal).to(result);
    }
  }]);
  return Plane;
}();

exports.default = Plane;
//# sourceMappingURL=plane.js.map