import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Vector3 } from '@math.gl/core';
import { INTERSECTION } from '../../constants';
const scratchVector = new Vector3();
const scratchNormal = new Vector3();
export default class AxisAlignedBoundingBox {
  constructor(minimum = [0, 0, 0], maximum = [0, 0, 0], center) {
    _defineProperty(this, "center", void 0);

    _defineProperty(this, "halfDiagonal", void 0);

    _defineProperty(this, "minimum", void 0);

    _defineProperty(this, "maximum", void 0);

    center = center || scratchVector.copy(minimum).add(maximum).scale(0.5);
    this.center = new Vector3(center);
    this.halfDiagonal = new Vector3(maximum).subtract(this.center);
    this.minimum = new Vector3(minimum);
    this.maximum = new Vector3(maximum);
  }

  clone() {
    return new AxisAlignedBoundingBox(this.minimum, this.maximum, this.center);
  }

  equals(right) {
    return this === right || Boolean(right) && this.minimum.equals(right.minimum) && this.maximum.equals(right.maximum);
  }

  transform(transform) {
    this.center.transformAsPoint(transform);
    this.halfDiagonal.transform(transform);
    this.minimum.transform(transform);
    this.maximum.transform(transform);
    return this;
  }

  intersectPlane(plane) {
    const {
      halfDiagonal
    } = this;
    const normal = scratchNormal.from(plane.normal);
    const e = halfDiagonal.x * Math.abs(normal.x) + halfDiagonal.y * Math.abs(normal.y) + halfDiagonal.z * Math.abs(normal.z);
    const s = this.center.dot(normal) + plane.distance;

    if (s - e > 0) {
      return INTERSECTION.INSIDE;
    }

    if (s + e < 0) {
      return INTERSECTION.OUTSIDE;
    }

    return INTERSECTION.INTERSECTING;
  }

  distanceTo(point) {
    return Math.sqrt(this.distanceSquaredTo(point));
  }

  distanceSquaredTo(point) {
    const offset = scratchVector.from(point).subtract(this.center);
    const {
      halfDiagonal
    } = this;
    let distanceSquared = 0.0;
    let d;
    d = Math.abs(offset.x) - halfDiagonal.x;

    if (d > 0) {
      distanceSquared += d * d;
    }

    d = Math.abs(offset.y) - halfDiagonal.y;

    if (d > 0) {
      distanceSquared += d * d;
    }

    d = Math.abs(offset.z) - halfDiagonal.z;

    if (d > 0) {
      distanceSquared += d * d;
    }

    return distanceSquared;
  }

}
//# sourceMappingURL=axis-aligned-bounding-box.js.map