import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Vector3, assert } from '@math.gl/core';
import { INTERSECTION } from '../constants';
import Plane from './plane';
const faces = [new Vector3([1, 0, 0]), new Vector3([0, 1, 0]), new Vector3([0, 0, 1])];
const scratchPlaneCenter = new Vector3();
const scratchPlaneNormal = new Vector3();
const scratchPlane = new Plane(new Vector3(1.0, 0.0, 0.0), 0.0);
export default class CullingVolume {
  constructor(planes = []) {
    _defineProperty(this, "planes", void 0);

    this.planes = planes;
  }

  fromBoundingSphere(boundingSphere) {
    this.planes.length = 2 * faces.length;
    const center = boundingSphere.center;
    const radius = boundingSphere.radius;
    let planeIndex = 0;

    for (const faceNormal of faces) {
      let plane0 = this.planes[planeIndex];
      let plane1 = this.planes[planeIndex + 1];

      if (!plane0) {
        plane0 = this.planes[planeIndex] = new Plane();
      }

      if (!plane1) {
        plane1 = this.planes[planeIndex + 1] = new Plane();
      }

      const plane0Center = scratchPlaneCenter.copy(faceNormal).scale(-radius).add(center);
      const plane0Distance = -faceNormal.dot(plane0Center);
      plane0.fromPointNormal(plane0Center, faceNormal);
      const plane1Center = scratchPlaneCenter.copy(faceNormal).scale(radius).add(center);
      const negatedFaceNormal = scratchPlaneNormal.copy(faceNormal).negate();
      const plane1Distance = -negatedFaceNormal.dot(plane1Center);
      plane1.fromPointNormal(plane1Center, negatedFaceNormal);
      planeIndex += 2;
    }

    return this;
  }

  computeVisibility(boundingVolume) {
    let intersect = INTERSECTION.INSIDE;

    for (const plane of this.planes) {
      const result = boundingVolume.intersectPlane(plane);

      switch (result) {
        case INTERSECTION.OUTSIDE:
          return INTERSECTION.OUTSIDE;

        case INTERSECTION.INTERSECTING:
          intersect = INTERSECTION.INTERSECTING;
          break;

        default:
      }
    }

    return intersect;
  }

  computeVisibilityWithPlaneMask(boundingVolume, parentPlaneMask) {
    assert(Number.isFinite(parentPlaneMask), 'parentPlaneMask is required.');

    if (parentPlaneMask === CullingVolume.MASK_OUTSIDE || parentPlaneMask === CullingVolume.MASK_INSIDE) {
      return parentPlaneMask;
    }

    let mask = CullingVolume.MASK_INSIDE;
    const planes = this.planes;

    for (let k = 0; k < this.planes.length; ++k) {
      const flag = k < 31 ? 1 << k : 0;

      if (k < 31 && (parentPlaneMask & flag) === 0) {
        continue;
      }

      const plane = planes[k];
      const result = boundingVolume.intersectPlane(plane);

      if (result === INTERSECTION.OUTSIDE) {
        return CullingVolume.MASK_OUTSIDE;
      } else if (result === INTERSECTION.INTERSECTING) {
        mask |= flag;
      }
    }

    return mask;
  }

}

_defineProperty(CullingVolume, "MASK_OUTSIDE", 0xffffffff);

_defineProperty(CullingVolume, "MASK_INSIDE", 0x00000000);

_defineProperty(CullingVolume, "MASK_INDETERMINATE", 0x7fffffff);
//# sourceMappingURL=culling-volume.js.map