import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Vector3, equals, assert } from '@math.gl/core';
const scratchPosition = new Vector3();
const scratchNormal = new Vector3();
export default class Plane {
  constructor(normal = [0, 0, 1], distance = 0) {
    _defineProperty(this, "normal", void 0);

    _defineProperty(this, "distance", void 0);

    this.normal = new Vector3();
    this.distance = -0;
    this.fromNormalDistance(normal, distance);
  }

  fromNormalDistance(normal, distance) {
    assert(Number.isFinite(distance));
    this.normal.from(normal).normalize();
    this.distance = distance;
    return this;
  }

  fromPointNormal(point, normal) {
    point = scratchPosition.from(point);
    this.normal.from(normal).normalize();
    const distance = -this.normal.dot(point);
    this.distance = distance;
    return this;
  }

  fromCoefficients(a, b, c, d) {
    this.normal.set(a, b, c);
    assert(equals(this.normal.len(), 1));
    this.distance = d;
    return this;
  }

  clone() {
    return new Plane(this.normal, this.distance);
  }

  equals(right) {
    return equals(this.distance, right.distance) && equals(this.normal, right.normal);
  }

  getPointDistance(point) {
    return this.normal.dot(point) + this.distance;
  }

  transform(matrix4) {
    const normal = scratchNormal.copy(this.normal).transformAsVector(matrix4).normalize();
    const point = this.normal.scale(-this.distance).transform(matrix4);
    return this.fromPointNormal(point, normal);
  }

  projectPointOntoPlane(point, result = [0, 0, 0]) {
    point = scratchPosition.from(point);
    const pointDistance = this.getPointDistance(point);
    const scaledNormal = scratchNormal.copy(this.normal).scale(pointDistance);
    return point.subtract(scaledNormal).to(result);
  }

}
//# sourceMappingURL=plane.js.map