import { Vector3, NumericArray } from '@math.gl/core';
export default class Plane {
    readonly normal: Vector3;
    distance: number;
    constructor(normal?: Readonly<NumericArray>, distance?: number);
    /** Creates a plane from a normal and a distance from the origin. */
    fromNormalDistance(normal: Readonly<NumericArray>, distance: number): this;
    /** Creates a plane from a normal and a point on the plane. */
    fromPointNormal(point: Readonly<NumericArray>, normal: Readonly<NumericArray>): this;
    /** Creates a plane from the general equation */
    fromCoefficients(a: number, b: number, c: number, d: number): this;
    /** Duplicates a Plane instance. */
    clone(): Plane;
    /** Compares the provided Planes by normal and distance */
    equals(right: Plane): boolean;
    /** Computes the signed shortest distance of a point to a plane.
     * The sign of the distance determines which side of the plane the point is on.
     */
    getPointDistance(point: Readonly<NumericArray>): number;
    /** Transforms the plane by the given transformation matrix. */
    transform(matrix4: Readonly<NumericArray>): this;
    /** Projects a point onto the plane. */
    projectPointOntoPlane(point: Readonly<NumericArray>, result: Vector3): Vector3;
    projectPointOntoPlane(point: Readonly<NumericArray>, result?: readonly number[]): readonly number[];
}
//# sourceMappingURL=plane.d.ts.map