"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WGS84_CONSTANTS = exports.WGS84_RADIUS_Z = exports.WGS84_RADIUS_Y = exports.WGS84_RADIUS_X = void 0;
var WGS84_RADIUS_X = 6378137.0;
exports.WGS84_RADIUS_X = WGS84_RADIUS_X;
var WGS84_RADIUS_Y = 6378137.0;
exports.WGS84_RADIUS_Y = WGS84_RADIUS_Y;
var WGS84_RADIUS_Z = 6356752.3142451793;
exports.WGS84_RADIUS_Z = WGS84_RADIUS_Z;
var WGS84_CONSTANTS = {
  radii: [WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z],
  radiiSquared: [WGS84_RADIUS_X * WGS84_RADIUS_X, WGS84_RADIUS_Y * WGS84_RADIUS_Y, WGS84_RADIUS_Z * WGS84_RADIUS_Z],
  oneOverRadii: [1.0 / WGS84_RADIUS_X, 1.0 / WGS84_RADIUS_Y, 1.0 / WGS84_RADIUS_Z],
  oneOverRadiiSquared: [1.0 / (WGS84_RADIUS_X * WGS84_RADIUS_X), 1.0 / (WGS84_RADIUS_Y * WGS84_RADIUS_Y), 1.0 / (WGS84_RADIUS_Z * WGS84_RADIUS_Z)],
  maximumRadius: Math.max(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z),
  centerToleranceSquared: 1e-1
};
exports.WGS84_CONSTANTS = WGS84_CONSTANTS;
//# sourceMappingURL=constants.js.map