"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var vec3 = _interopRequireWildcard(require("gl-matrix/vec3"));

var _constants = require("../constants");

var _typeUtils = require("../type-utils");

var _scaleToGeodeticSurface2 = _interopRequireDefault(require("./helpers/scale-to-geodetic-surface"));

var _ellipsoidTransform = _interopRequireDefault(require("./helpers/ellipsoid-transform"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var scratchVector = new _core.Vector3();
var scratchNormal = new _core.Vector3();
var scratchK = new _core.Vector3();
var scratchPosition = new _core.Vector3();
var scratchHeight = new _core.Vector3();
var scratchCartesian = new _core.Vector3();
var wgs84;

var Ellipsoid = function () {
  function Ellipsoid() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0.0;
    (0, _classCallCheck2.default)(this, Ellipsoid);
    (0, _defineProperty2.default)(this, "radii", void 0);
    (0, _defineProperty2.default)(this, "radiiSquared", void 0);
    (0, _defineProperty2.default)(this, "radiiToTheFourth", void 0);
    (0, _defineProperty2.default)(this, "oneOverRadii", void 0);
    (0, _defineProperty2.default)(this, "oneOverRadiiSquared", void 0);
    (0, _defineProperty2.default)(this, "minimumRadius", void 0);
    (0, _defineProperty2.default)(this, "maximumRadius", void 0);
    (0, _defineProperty2.default)(this, "centerToleranceSquared", _core._MathUtils.EPSILON1);
    (0, _defineProperty2.default)(this, "squaredXOverSquaredZ", void 0);
    (0, _core.assert)(x >= 0.0);
    (0, _core.assert)(y >= 0.0);
    (0, _core.assert)(z >= 0.0);
    this.radii = new _core.Vector3(x, y, z);
    this.radiiSquared = new _core.Vector3(x * x, y * y, z * z);
    this.radiiToTheFourth = new _core.Vector3(x * x * x * x, y * y * y * y, z * z * z * z);
    this.oneOverRadii = new _core.Vector3(x === 0.0 ? 0.0 : 1.0 / x, y === 0.0 ? 0.0 : 1.0 / y, z === 0.0 ? 0.0 : 1.0 / z);
    this.oneOverRadiiSquared = new _core.Vector3(x === 0.0 ? 0.0 : 1.0 / (x * x), y === 0.0 ? 0.0 : 1.0 / (y * y), z === 0.0 ? 0.0 : 1.0 / (z * z));
    this.minimumRadius = Math.min(x, y, z);
    this.maximumRadius = Math.max(x, y, z);

    if (this.radiiSquared.z !== 0) {
      this.squaredXOverSquaredZ = this.radiiSquared.x / this.radiiSquared.z;
    }

    Object.freeze(this);
  }

  (0, _createClass2.default)(Ellipsoid, [{
    key: "equals",
    value: function equals(right) {
      return this === right || Boolean(right && this.radii.equals(right.radii));
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.radii.toString();
    }
  }, {
    key: "cartographicToCartesian",
    value: function cartographicToCartesian(cartographic) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      var normal = scratchNormal;
      var k = scratchK;

      var _cartographic = (0, _slicedToArray2.default)(cartographic, 3),
          height = _cartographic[2];

      this.geodeticSurfaceNormalCartographic(cartographic, normal);
      k.copy(this.radiiSquared).scale(normal);
      var gamma = Math.sqrt(normal.dot(k));
      k.scale(1 / gamma);
      normal.scale(height);
      k.add(normal);
      return k.to(result);
    }
  }, {
    key: "cartesianToCartographic",
    value: function cartesianToCartographic(cartesian) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      scratchCartesian.from(cartesian);
      var point = this.scaleToGeodeticSurface(scratchCartesian, scratchPosition);

      if (!point) {
        return undefined;
      }

      var normal = this.geodeticSurfaceNormal(point, scratchNormal);
      var h = scratchHeight;
      h.copy(scratchCartesian).subtract(point);
      var longitude = Math.atan2(normal.y, normal.x);
      var latitude = Math.asin(normal.z);
      var height = Math.sign(vec3.dot(h, scratchCartesian)) * vec3.length(h);
      return (0, _typeUtils.toCartographicFromRadians)([longitude, latitude, height], result);
    }
  }, {
    key: "eastNorthUpToFixedFrame",
    value: function eastNorthUpToFixedFrame(origin) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _core.Matrix4();
      return (0, _ellipsoidTransform.default)(this, 'east', 'north', 'up', origin, result);
    }
  }, {
    key: "localFrameToFixedFrame",
    value: function localFrameToFixedFrame(firstAxis, secondAxis, thirdAxis, origin) {
      var result = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : new _core.Matrix4();
      return (0, _ellipsoidTransform.default)(this, firstAxis, secondAxis, thirdAxis, origin, result);
    }
  }, {
    key: "geocentricSurfaceNormal",
    value: function geocentricSurfaceNormal(cartesian) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      return scratchVector.from(cartesian).normalize().to(result);
    }
  }, {
    key: "geodeticSurfaceNormalCartographic",
    value: function geodeticSurfaceNormalCartographic(cartographic) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      var cartographicVectorRadians = (0, _typeUtils.fromCartographicToRadians)(cartographic);
      var longitude = cartographicVectorRadians[0];
      var latitude = cartographicVectorRadians[1];
      var cosLatitude = Math.cos(latitude);
      scratchVector.set(cosLatitude * Math.cos(longitude), cosLatitude * Math.sin(longitude), Math.sin(latitude)).normalize();
      return scratchVector.to(result);
    }
  }, {
    key: "geodeticSurfaceNormal",
    value: function geodeticSurfaceNormal(cartesian) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      return scratchVector.from(cartesian).scale(this.oneOverRadiiSquared).normalize().to(result);
    }
  }, {
    key: "scaleToGeodeticSurface",
    value: function scaleToGeodeticSurface(cartesian, result) {
      return (0, _scaleToGeodeticSurface2.default)(cartesian, this, result);
    }
  }, {
    key: "scaleToGeocentricSurface",
    value: function scaleToGeocentricSurface(cartesian) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      scratchPosition.from(cartesian);
      var positionX = scratchPosition.x;
      var positionY = scratchPosition.y;
      var positionZ = scratchPosition.z;
      var oneOverRadiiSquared = this.oneOverRadiiSquared;
      var beta = 1.0 / Math.sqrt(positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z);
      return scratchPosition.multiplyScalar(beta).to(result);
    }
  }, {
    key: "transformPositionToScaledSpace",
    value: function transformPositionToScaledSpace(position) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      return scratchPosition.from(position).scale(this.oneOverRadii).to(result);
    }
  }, {
    key: "transformPositionFromScaledSpace",
    value: function transformPositionFromScaledSpace(position) {
      var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0];
      return scratchPosition.from(position).scale(this.radii).to(result);
    }
  }, {
    key: "getSurfaceNormalIntersectionWithZAxis",
    value: function getSurfaceNormalIntersectionWithZAxis(position) {
      var buffer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var result = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [0, 0, 0];
      (0, _core.assert)((0, _core.equals)(this.radii.x, this.radii.y, _core._MathUtils.EPSILON15));
      (0, _core.assert)(this.radii.z > 0);
      scratchPosition.from(position);
      var z = scratchPosition.z * (1 - this.squaredXOverSquaredZ);

      if (Math.abs(z) >= this.radii.z - buffer) {
        return undefined;
      }

      return scratchPosition.set(0.0, 0.0, z).to(result);
    }
  }]);
  return Ellipsoid;
}();

exports.default = Ellipsoid;
(0, _defineProperty2.default)(Ellipsoid, "WGS84", new Ellipsoid(_constants.WGS84_RADIUS_X, _constants.WGS84_RADIUS_Y, _constants.WGS84_RADIUS_Z));
//# sourceMappingURL=ellipsoid.js.map