"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = localFrameToFixedFrame;

var _core = require("@math.gl/core");

var EPSILON14 = 1e-14;
var scratchOrigin = new _core.Vector3();
var VECTOR_PRODUCT_LOCAL_FRAME = {
  up: {
    south: 'east',
    north: 'west',
    west: 'south',
    east: 'north'
  },
  down: {
    south: 'west',
    north: 'east',
    west: 'north',
    east: 'south'
  },
  south: {
    up: 'west',
    down: 'east',
    west: 'down',
    east: 'up'
  },
  north: {
    up: 'east',
    down: 'west',
    west: 'up',
    east: 'down'
  },
  west: {
    up: 'north',
    down: 'south',
    north: 'down',
    south: 'up'
  },
  east: {
    up: 'south',
    down: 'north',
    north: 'up',
    south: 'down'
  }
};
var degeneratePositionLocalFrame = {
  north: [-1, 0, 0],
  east: [0, 1, 0],
  up: [0, 0, 1],
  south: [1, 0, 0],
  west: [0, -1, 0],
  down: [0, 0, -1]
};
var scratchAxisVectors = {
  east: new _core.Vector3(),
  north: new _core.Vector3(),
  up: new _core.Vector3(),
  west: new _core.Vector3(),
  south: new _core.Vector3(),
  down: new _core.Vector3()
};
var scratchVector1 = new _core.Vector3();
var scratchVector2 = new _core.Vector3();
var scratchVector3 = new _core.Vector3();

function localFrameToFixedFrame(ellipsoid, firstAxis, secondAxis, thirdAxis, cartesianOrigin, result) {
  var thirdAxisInferred = VECTOR_PRODUCT_LOCAL_FRAME[firstAxis] && VECTOR_PRODUCT_LOCAL_FRAME[firstAxis][secondAxis];
  (0, _core.assert)(thirdAxisInferred && (!thirdAxis || thirdAxis === thirdAxisInferred));
  var firstAxisVector;
  var secondAxisVector;
  var thirdAxisVector;
  var origin = scratchOrigin.copy(cartesianOrigin);
  var atPole = (0, _core.equals)(origin.x, 0.0, EPSILON14) && (0, _core.equals)(origin.y, 0.0, EPSILON14);

  if (atPole) {
    var sign = Math.sign(origin.z);
    firstAxisVector = scratchVector1.fromArray(degeneratePositionLocalFrame[firstAxis]);

    if (firstAxis !== 'east' && firstAxis !== 'west') {
      firstAxisVector.scale(sign);
    }

    secondAxisVector = scratchVector2.fromArray(degeneratePositionLocalFrame[secondAxis]);

    if (secondAxis !== 'east' && secondAxis !== 'west') {
      secondAxisVector.scale(sign);
    }

    thirdAxisVector = scratchVector3.fromArray(degeneratePositionLocalFrame[thirdAxis]);

    if (thirdAxis !== 'east' && thirdAxis !== 'west') {
      thirdAxisVector.scale(sign);
    }
  } else {
    var up = scratchAxisVectors.up,
        east = scratchAxisVectors.east,
        north = scratchAxisVectors.north;
    east.set(-origin.y, origin.x, 0.0).normalize();
    ellipsoid.geodeticSurfaceNormal(origin, up);
    north.copy(up).cross(east);
    var down = scratchAxisVectors.down,
        west = scratchAxisVectors.west,
        south = scratchAxisVectors.south;
    down.copy(up).scale(-1);
    west.copy(east).scale(-1);
    south.copy(north).scale(-1);
    firstAxisVector = scratchAxisVectors[firstAxis];
    secondAxisVector = scratchAxisVectors[secondAxis];
    thirdAxisVector = scratchAxisVectors[thirdAxis];
  }

  result[0] = firstAxisVector.x;
  result[1] = firstAxisVector.y;
  result[2] = firstAxisVector.z;
  result[3] = 0.0;
  result[4] = secondAxisVector.x;
  result[5] = secondAxisVector.y;
  result[6] = secondAxisVector.z;
  result[7] = 0.0;
  result[8] = thirdAxisVector.x;
  result[9] = thirdAxisVector.y;
  result[10] = thirdAxisVector.z;
  result[11] = 0.0;
  result[12] = origin.x;
  result[13] = origin.y;
  result[14] = origin.z;
  result[15] = 1.0;
  return result;
}
//# sourceMappingURL=ellipsoid-transform.js.map