"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = scaleToGeodeticSurface;

var _core = require("@math.gl/core");

var scratchVector = new _core.Vector3();
var scaleToGeodeticSurfaceIntersection = new _core.Vector3();
var scaleToGeodeticSurfaceGradient = new _core.Vector3();

function scaleToGeodeticSurface(cartesian, ellipsoid) {
  var result = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var oneOverRadii = ellipsoid.oneOverRadii,
      oneOverRadiiSquared = ellipsoid.oneOverRadiiSquared,
      centerToleranceSquared = ellipsoid.centerToleranceSquared;
  scratchVector.from(cartesian);
  var positionX = scratchVector.x;
  var positionY = scratchVector.y;
  var positionZ = scratchVector.z;
  var oneOverRadiiX = oneOverRadii.x;
  var oneOverRadiiY = oneOverRadii.y;
  var oneOverRadiiZ = oneOverRadii.z;
  var x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
  var y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
  var z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
  var squaredNorm = x2 + y2 + z2;
  var ratio = Math.sqrt(1.0 / squaredNorm);

  if (!Number.isFinite(ratio)) {
    return undefined;
  }

  var intersection = scaleToGeodeticSurfaceIntersection;
  intersection.copy(cartesian).scale(ratio);

  if (squaredNorm < centerToleranceSquared) {
    return intersection.to(result);
  }

  var oneOverRadiiSquaredX = oneOverRadiiSquared.x;
  var oneOverRadiiSquaredY = oneOverRadiiSquared.y;
  var oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
  var gradient = scaleToGeodeticSurfaceGradient;
  gradient.set(intersection.x * oneOverRadiiSquaredX * 2.0, intersection.y * oneOverRadiiSquaredY * 2.0, intersection.z * oneOverRadiiSquaredZ * 2.0);
  var lambda = (1.0 - ratio) * scratchVector.len() / (0.5 * gradient.len());
  var correction = 0.0;
  var xMultiplier;
  var yMultiplier;
  var zMultiplier;
  var func;

  do {
    lambda -= correction;
    xMultiplier = 1.0 / (1.0 + lambda * oneOverRadiiSquaredX);
    yMultiplier = 1.0 / (1.0 + lambda * oneOverRadiiSquaredY);
    zMultiplier = 1.0 / (1.0 + lambda * oneOverRadiiSquaredZ);
    var xMultiplier2 = xMultiplier * xMultiplier;
    var yMultiplier2 = yMultiplier * yMultiplier;
    var zMultiplier2 = zMultiplier * zMultiplier;
    var xMultiplier3 = xMultiplier2 * xMultiplier;
    var yMultiplier3 = yMultiplier2 * yMultiplier;
    var zMultiplier3 = zMultiplier2 * zMultiplier;
    func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1.0;
    var denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
    var derivative = -2.0 * denominator;
    correction = func / derivative;
  } while (Math.abs(func) > _core._MathUtils.EPSILON12);

  return scratchVector.scale([xMultiplier, yMultiplier, zMultiplier]).to(result);
}
//# sourceMappingURL=scale-to-geodetic-surface.js.map