export const WGS84_RADIUS_X = 6378137.0;
export const WGS84_RADIUS_Y = 6378137.0;
export const WGS84_RADIUS_Z = 6356752.3142451793;
export const WGS84_CONSTANTS = {
  radii: [WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z],
  radiiSquared: [WGS84_RADIUS_X * WGS84_RADIUS_X, WGS84_RADIUS_Y * WGS84_RADIUS_Y, WGS84_RADIUS_Z * WGS84_RADIUS_Z],
  oneOverRadii: [1.0 / WGS84_RADIUS_X, 1.0 / WGS84_RADIUS_Y, 1.0 / WGS84_RADIUS_Z],
  oneOverRadiiSquared: [1.0 / (WGS84_RADIUS_X * WGS84_RADIUS_X), 1.0 / (WGS84_RADIUS_Y * WGS84_RADIUS_Y), 1.0 / (WGS84_RADIUS_Z * WGS84_RADIUS_Z)],
  maximumRadius: Math.max(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z),
  centerToleranceSquared: 1e-1
};
//# sourceMappingURL=constants.js.map