import type { NumericArray } from '@math.gl/core';
declare type LngLatHeightObject = {
    longitude: number;
    latitude: number;
    height: number;
};
declare type XYZObject = {
    x: number;
    y: number;
    z: number;
};
declare type Cartographic = LngLatHeightObject | XYZObject | NumericArray;
export declare function fromCartographic(cartographic: Cartographic): number[];
export declare function fromCartographic<NumArrayT>(cartographic: Cartographic, result: NumArrayT, map?: (x: number) => number): NumArrayT;
export declare function fromCartographicToRadians(cartographic: Cartographic, result?: number[]): number[];
export declare function fromCartographicToRadians<TArray>(cartographic: Cartographic, result: TArray): TArray;
export declare function fromCartographicToDegrees(cartographic: Cartographic, result?: number[]): number[];
export declare function fromCartographicToDegrees<TArray>(cartographic: Cartographic, result: TArray): TArray;
export declare function toCartographic<T extends Cartographic>(vector: Readonly<NumericArray>, cartographic: T, map?: (x: number) => number): T;
export declare function toCartographicFromRadians<T extends Cartographic>(vector: Readonly<NumericArray>, cartographic: T): T;
export declare function toCartographicFromDegrees<T extends Cartographic>(vector: Readonly<NumericArray>, cartographic: T): T;
export declare function isWGS84(vector: Readonly<NumericArray>): boolean;
export {};
//# sourceMappingURL=type-utils.d.ts.map