"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cutPolylineByMercatorBounds = cutPolylineByMercatorBounds;
exports.cutPolygonByMercatorBounds = cutPolygonByMercatorBounds;

var _cutByGrid = require("./cut-by-grid");

var _utils = require("./utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var DEFAULT_MAX_LATITUDE = 85.051129;

function cutPolylineByMercatorBounds(positions, options) {
  var _ref = options || {},
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 2 : _ref$size,
      _ref$startIndex = _ref.startIndex,
      startIndex = _ref$startIndex === void 0 ? 0 : _ref$startIndex,
      _ref$endIndex = _ref.endIndex,
      endIndex = _ref$endIndex === void 0 ? positions.length : _ref$endIndex,
      _ref$normalize = _ref.normalize,
      normalize = _ref$normalize === void 0 ? true : _ref$normalize;

  var newPositions = positions.slice(startIndex, endIndex);
  wrapLongitudesForShortestPath(newPositions, size, 0, endIndex - startIndex);
  var parts = (0, _cutByGrid.cutPolylineByGrid)(newPositions, {
    size: size,
    broken: true,
    gridResolution: 360,
    gridOffset: [-180, -180]
  });

  if (normalize) {
    var _iterator = _createForOfIteratorHelper(parts),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var part = _step.value;
        shiftLongitudesIntoRange(part, size);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }

  return parts;
}

function cutPolygonByMercatorBounds(positions) {
  var holeIndices = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  var options = arguments.length > 2 ? arguments[2] : undefined;

  var _ref2 = options || {},
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? 2 : _ref2$size,
      _ref2$normalize = _ref2.normalize,
      normalize = _ref2$normalize === void 0 ? true : _ref2$normalize,
      _ref2$edgeTypes = _ref2.edgeTypes,
      edgeTypes = _ref2$edgeTypes === void 0 ? false : _ref2$edgeTypes;

  holeIndices = holeIndices || [];
  var newPositions = [];
  var newHoleIndices = [];
  var srcStartIndex = 0;
  var targetIndex = 0;

  for (var ringIndex = 0; ringIndex <= holeIndices.length; ringIndex++) {
    var srcEndIndex = holeIndices[ringIndex] || positions.length;
    var targetStartIndex = targetIndex;
    var splitIndex = findSplitIndex(positions, size, srcStartIndex, srcEndIndex);

    for (var i = splitIndex; i < srcEndIndex; i++) {
      newPositions[targetIndex++] = positions[i];
    }

    for (var _i = srcStartIndex; _i < splitIndex; _i++) {
      newPositions[targetIndex++] = positions[_i];
    }

    wrapLongitudesForShortestPath(newPositions, size, targetStartIndex, targetIndex);
    insertPoleVertices(newPositions, size, targetStartIndex, targetIndex, options === null || options === void 0 ? void 0 : options.maxLatitude);
    srcStartIndex = srcEndIndex;
    newHoleIndices[ringIndex] = targetIndex;
  }

  newHoleIndices.pop();
  var parts = (0, _cutByGrid.cutPolygonByGrid)(newPositions, newHoleIndices, {
    size: size,
    gridResolution: 360,
    gridOffset: [-180, -180],
    edgeTypes: edgeTypes
  });

  if (normalize) {
    var _iterator2 = _createForOfIteratorHelper(parts),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var part = _step2.value;
        shiftLongitudesIntoRange(part.positions, size);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }

  return parts;
}

function findSplitIndex(positions, size, startIndex, endIndex) {
  var maxLat = -1;
  var pointIndex = -1;

  for (var i = startIndex + 1; i < endIndex; i += size) {
    var lat = Math.abs(positions[i]);

    if (lat > maxLat) {
      maxLat = lat;
      pointIndex = i - 1;
    }
  }

  return pointIndex;
}

function insertPoleVertices(positions, size, startIndex, endIndex) {
  var maxLatitude = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : DEFAULT_MAX_LATITUDE;
  var firstLng = positions[startIndex];
  var lastLng = positions[endIndex - size];

  if (Math.abs(firstLng - lastLng) > 180) {
    var p = (0, _utils.getPointAtIndex)(positions, 0, size, startIndex);
    p[0] += Math.round((lastLng - firstLng) / 360) * 360;
    (0, _utils.push)(positions, p);
    p[1] = Math.sign(p[1]) * maxLatitude;
    (0, _utils.push)(positions, p);
    p[0] = firstLng;
    (0, _utils.push)(positions, p);
  }
}

function wrapLongitudesForShortestPath(positions, size, startIndex, endIndex) {
  var prevLng = positions[0];
  var lng;

  for (var i = startIndex; i < endIndex; i += size) {
    lng = positions[i];
    var delta = lng - prevLng;

    if (delta > 180 || delta < -180) {
      lng -= Math.round(delta / 360) * 360;
    }

    positions[i] = prevLng = lng;
  }
}

function shiftLongitudesIntoRange(positions, size) {
  var refLng;
  var pointCount = positions.length / size;

  for (var i = 0; i < pointCount; i++) {
    refLng = positions[i * size];

    if ((refLng + 180) % 360 !== 0) {
      break;
    }
  }

  var delta = -Math.round(refLng / 360) * 360;

  if (delta === 0) {
    return;
  }

  for (var _i2 = 0; _i2 < pointCount; _i2++) {
    positions[_i2 * size] += delta;
  }
}
//# sourceMappingURL=cut-by-mercator-bounds.js.map