"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clipPolyline = clipPolyline;
exports.clipPolygon = clipPolygon;
exports.intersect = intersect;
exports.bitCode = bitCode;

var _utils = require("./utils");

function clipPolyline(positions, bbox, options) {
  var _ref = options || {},
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 2 : _ref$size,
      _ref$startIndex = _ref.startIndex,
      startIndex = _ref$startIndex === void 0 ? 0 : _ref$startIndex,
      _ref$endIndex = _ref.endIndex,
      endIndex = _ref$endIndex === void 0 ? positions.length : _ref$endIndex;

  var numPoints = (endIndex - startIndex) / size;
  var result = [];
  var part = [];
  var a;
  var b;
  var codeA = -1;
  var codeB;
  var lastCode;

  for (var i = 1; i < numPoints; i++) {
    a = (0, _utils.getPointAtIndex)(positions, i - 1, size, startIndex, a);
    b = (0, _utils.getPointAtIndex)(positions, i, size, startIndex, b);

    if (codeA < 0) {
      codeA = bitCode(a, bbox);
    }

    codeB = lastCode = bitCode(b, bbox);

    while (true) {
      if (!(codeA | codeB)) {
        (0, _utils.push)(part, a);

        if (codeB !== lastCode) {
          (0, _utils.push)(part, b);

          if (i < numPoints - 1) {
            result.push(part);
            part = [];
          }
        } else if (i === numPoints - 1) {
          (0, _utils.push)(part, b);
        }

        break;
      } else if (codeA & codeB) {
        break;
      } else if (codeA) {
        intersect(a, b, codeA, bbox, a);
        codeA = bitCode(a, bbox);
      } else {
        intersect(a, b, codeB, bbox, b);
        codeB = bitCode(b, bbox);
      }
    }

    codeA = lastCode;
  }

  if (part.length) result.push(part);
  return result;
}

function clipPolygon(positions, bbox, options) {
  var _ref2 = options || {},
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? 2 : _ref2$size,
      _ref2$endIndex = _ref2.endIndex,
      endIndex = _ref2$endIndex === void 0 ? positions.length : _ref2$endIndex;

  var _ref3 = options || {},
      _ref3$startIndex = _ref3.startIndex,
      startIndex = _ref3$startIndex === void 0 ? 0 : _ref3$startIndex;

  var numPoints = (endIndex - startIndex) / size;
  var result;
  var p;
  var prev;
  var inside;
  var prevInside;

  for (var edge = 1; edge <= 8; edge *= 2) {
    result = [];
    prev = (0, _utils.getPointAtIndex)(positions, numPoints - 1, size, startIndex, prev);
    prevInside = !(bitCode(prev, bbox) & edge);

    for (var i = 0; i < numPoints; i++) {
      p = (0, _utils.getPointAtIndex)(positions, i, size, startIndex, p);
      inside = !(bitCode(p, bbox) & edge);
      if (inside !== prevInside) (0, _utils.push)(result, intersect(prev, p, edge, bbox));
      if (inside) (0, _utils.push)(result, p);
      (0, _utils.copy)(prev, p);
      prevInside = inside;
    }

    positions = result;
    startIndex = 0;
    numPoints = result.length / size;
    if (!numPoints) break;
  }

  return result;
}

function intersect(a, b, edge, bbox) {
  var out = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
  var t;
  var snap;

  if (edge & 8) {
    t = (bbox[3] - a[1]) / (b[1] - a[1]);
    snap = 3;
  } else if (edge & 4) {
    t = (bbox[1] - a[1]) / (b[1] - a[1]);
    snap = 1;
  } else if (edge & 2) {
    t = (bbox[2] - a[0]) / (b[0] - a[0]);
    snap = 2;
  } else if (edge & 1) {
    t = (bbox[0] - a[0]) / (b[0] - a[0]);
    snap = 0;
  } else {
    return null;
  }

  for (var i = 0; i < a.length; i++) {
    out[i] = (snap & 1) === i ? bbox[snap] : t * (b[i] - a[i]) + a[i];
  }

  return out;
}

function bitCode(p, bbox) {
  var code = 0;
  if (p[0] < bbox[0]) code |= 1;else if (p[0] > bbox[2]) code |= 2;
  if (p[1] < bbox[1]) code |= 4;else if (p[1] > bbox[3]) code |= 8;
  return code;
}
//# sourceMappingURL=lineclip.js.map