"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modifyPolygonWindingDirection = modifyPolygonWindingDirection;
exports.getPolygonWindingDirection = getPolygonWindingDirection;
exports.getPolygonSignedArea = getPolygonSignedArea;
exports.forEachSegmentInPolygon = forEachSegmentInPolygon;
exports.modifyPolygonWindingDirectionPoints = modifyPolygonWindingDirectionPoints;
exports.getPolygonWindingDirectionPoints = getPolygonWindingDirectionPoints;
exports.getPolygonSignedAreaPoints = getPolygonSignedAreaPoints;
exports.forEachSegmentInPolygonPoints = forEachSegmentInPolygonPoints;
exports.WINDING = void 0;

var _core = require("@math.gl/core");

var WINDING = {
  CLOCKWISE: 1,
  COUNTER_CLOCKWISE: -1
};
exports.WINDING = WINDING;

function modifyPolygonWindingDirection(points, direction) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var windingDirection = getPolygonWindingDirection(points, options);

  if (windingDirection !== direction) {
    reversePolygon(points, options);
    return true;
  }

  return false;
}

function getPolygonWindingDirection(points) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return Math.sign(getPolygonSignedArea(points, options));
}

function getPolygonSignedArea(points) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$start = options.start,
      start = _options$start === void 0 ? 0 : _options$start,
      _options$end = options.end,
      end = _options$end === void 0 ? points.length : _options$end;
  var dim = options.size || 2;
  var area = 0;

  for (var i = start, j = end - dim; i < end; i += dim) {
    area += (points[i] - points[j]) * (points[i + 1] + points[j + 1]);
    j = i;
  }

  return area / 2;
}

function forEachSegmentInPolygon(points, visitor) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _options$start2 = options.start,
      start = _options$start2 === void 0 ? 0 : _options$start2,
      _options$end2 = options.end,
      end = _options$end2 === void 0 ? points.length : _options$end2,
      _options$size = options.size,
      size = _options$size === void 0 ? 2 : _options$size,
      isClosed = options.isClosed;
  var numPoints = (end - start) / size;

  for (var i = 0; i < numPoints - 1; ++i) {
    visitor(points[start + i * size], points[start + i * size + 1], points[start + (i + 1) * size], points[start + (i + 1) * size + 1], i, i + 1);
  }

  var endPointIndex = start + (numPoints - 1) * size;
  var isClosedEx = isClosed || (0, _core.equals)(points[start], points[endPointIndex]) && (0, _core.equals)(points[start + 1], points[endPointIndex + 1]);

  if (!isClosedEx) {
    visitor(points[endPointIndex], points[endPointIndex + 1], points[start], points[start + 1], numPoints - 1, 0);
  }
}

function reversePolygon(points, options) {
  var _options$start3 = options.start,
      start = _options$start3 === void 0 ? 0 : _options$start3,
      _options$end3 = options.end,
      end = _options$end3 === void 0 ? points.length : _options$end3,
      _options$size2 = options.size,
      size = _options$size2 === void 0 ? 2 : _options$size2;
  var numPoints = (end - start) / size;
  var numSwaps = Math.floor(numPoints / 2);

  for (var i = 0; i < numSwaps; ++i) {
    var b1 = start + i * size;
    var b2 = start + (numPoints - 1 - i) * size;

    for (var j = 0; j < size; ++j) {
      var tmp = points[b1 + j];
      points[b1 + j] = points[b2 + j];
      points[b2 + j] = tmp;
    }
  }
}

function modifyPolygonWindingDirectionPoints(points, direction) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var currentDirection = getPolygonWindingDirectionPoints(points, options);

  if (currentDirection !== direction) {
    points.reverse();
    return true;
  }

  return false;
}

function getPolygonWindingDirectionPoints(points) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return Math.sign(getPolygonSignedAreaPoints(points, options));
}

function getPolygonSignedAreaPoints(points) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$start4 = options.start,
      start = _options$start4 === void 0 ? 0 : _options$start4,
      _options$end4 = options.end,
      end = _options$end4 === void 0 ? points.length : _options$end4;
  var area = 0;

  for (var i = start, j = end - 1; i < end; ++i) {
    area += (points[i][0] - points[j][0]) * (points[i][1] + points[j][1]);
    j = i;
  }

  return area / 2;
}

function forEachSegmentInPolygonPoints(points, visitor) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _options$start5 = options.start,
      start = _options$start5 === void 0 ? 0 : _options$start5,
      _options$end5 = options.end,
      end = _options$end5 === void 0 ? points.length : _options$end5,
      isClosed = options.isClosed;

  for (var i = start; i < end - 1; ++i) {
    visitor(points[i], points[i + 1], i, i + 1);
  }

  var isClosedEx = isClosed || (0, _core.equals)(points[end - 1], points[0]);

  if (!isClosedEx) {
    visitor(points[end - 1], points[0], end - 1, 0);
  }
}
//# sourceMappingURL=polygon-utils.js.map