"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@math.gl/core");

var _polygonUtils = require("./polygon-utils");

var Polygon = function () {
  function Polygon(points) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Polygon);
    (0, _defineProperty2.default)(this, "points", void 0);
    (0, _defineProperty2.default)(this, "isFlatArray", void 0);
    (0, _defineProperty2.default)(this, "options", void 0);
    this.points = points;
    this.isFlatArray = !(0, _core.isArray)(points[0]);
    this.options = {
      start: options.start || 0,
      end: options.end || points.length,
      size: options.size || 2,
      isClosed: options.isClosed
    };
    Object.freeze(this);
  }

  (0, _createClass2.default)(Polygon, [{
    key: "getSignedArea",
    value: function getSignedArea() {
      if (this.isFlatArray) return (0, _polygonUtils.getPolygonSignedArea)(this.points, this.options);
      return (0, _polygonUtils.getPolygonSignedAreaPoints)(this.points, this.options);
    }
  }, {
    key: "getArea",
    value: function getArea() {
      return Math.abs(this.getSignedArea());
    }
  }, {
    key: "getWindingDirection",
    value: function getWindingDirection() {
      return Math.sign(this.getSignedArea());
    }
  }, {
    key: "forEachSegment",
    value: function forEachSegment(visitor) {
      if (this.isFlatArray) {
        (0, _polygonUtils.forEachSegmentInPolygon)(this.points, function (x1, y1, x2, y2, i1, i2) {
          visitor([x1, y1], [x2, y2], i1, i2);
        }, this.options);
      } else {
        (0, _polygonUtils.forEachSegmentInPolygonPoints)(this.points, visitor, this.options);
      }
    }
  }, {
    key: "modifyWindingDirection",
    value: function modifyWindingDirection(direction) {
      if (this.isFlatArray) {
        return (0, _polygonUtils.modifyPolygonWindingDirection)(this.points, direction, this.options);
      }

      return (0, _polygonUtils.modifyPolygonWindingDirectionPoints)(this.points, direction, this.options);
    }
  }]);
  return Polygon;
}();

exports.default = Polygon;
//# sourceMappingURL=polygon.js.map