"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.push = push;
exports.copy = copy;
exports.getPointAtIndex = getPointAtIndex;

function push(target, source) {
  var size = source.length;
  var startIndex = target.length;

  if (startIndex > 0) {
    var isDuplicate = true;

    for (var i = 0; i < size; i++) {
      if (target[startIndex - size + i] !== source[i]) {
        isDuplicate = false;
        break;
      }
    }

    if (isDuplicate) {
      return false;
    }
  }

  for (var _i = 0; _i < size; _i++) {
    target[startIndex + _i] = source[_i];
  }

  return true;
}

function copy(target, source) {
  var size = source.length;

  for (var i = 0; i < size; i++) {
    target[i] = source[i];
  }
}

function getPointAtIndex(positions, index, size, offset) {
  var out = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
  var startI = offset + index * size;

  for (var i = 0; i < size; i++) {
    out[i] = positions[startI + i];
  }

  return out;
}
//# sourceMappingURL=utils.js.map