import { push, copy, getPointAtIndex } from './utils';
export function clipPolyline(positions, bbox, options) {
  const {
    size = 2,
    startIndex = 0,
    endIndex = positions.length
  } = options || {};
  const numPoints = (endIndex - startIndex) / size;
  const result = [];
  let part = [];
  let a;
  let b;
  let codeA = -1;
  let codeB;
  let lastCode;

  for (let i = 1; i < numPoints; i++) {
    a = getPointAtIndex(positions, i - 1, size, startIndex, a);
    b = getPointAtIndex(positions, i, size, startIndex, b);

    if (codeA < 0) {
      codeA = bitCode(a, bbox);
    }

    codeB = lastCode = bitCode(b, bbox);

    while (true) {
      if (!(codeA | codeB)) {
        push(part, a);

        if (codeB !== lastCode) {
          push(part, b);

          if (i < numPoints - 1) {
            result.push(part);
            part = [];
          }
        } else if (i === numPoints - 1) {
          push(part, b);
        }

        break;
      } else if (codeA & codeB) {
        break;
      } else if (codeA) {
        intersect(a, b, codeA, bbox, a);
        codeA = bitCode(a, bbox);
      } else {
        intersect(a, b, codeB, bbox, b);
        codeB = bitCode(b, bbox);
      }
    }

    codeA = lastCode;
  }

  if (part.length) result.push(part);
  return result;
}
export function clipPolygon(positions, bbox, options) {
  const {
    size = 2,
    endIndex = positions.length
  } = options || {};
  let {
    startIndex = 0
  } = options || {};
  let numPoints = (endIndex - startIndex) / size;
  let result;
  let p;
  let prev;
  let inside;
  let prevInside;

  for (let edge = 1; edge <= 8; edge *= 2) {
    result = [];
    prev = getPointAtIndex(positions, numPoints - 1, size, startIndex, prev);
    prevInside = !(bitCode(prev, bbox) & edge);

    for (let i = 0; i < numPoints; i++) {
      p = getPointAtIndex(positions, i, size, startIndex, p);
      inside = !(bitCode(p, bbox) & edge);
      if (inside !== prevInside) push(result, intersect(prev, p, edge, bbox));
      if (inside) push(result, p);
      copy(prev, p);
      prevInside = inside;
    }

    positions = result;
    startIndex = 0;
    numPoints = result.length / size;
    if (!numPoints) break;
  }

  return result;
}
export function intersect(a, b, edge, bbox, out = []) {
  let t;
  let snap;

  if (edge & 8) {
    t = (bbox[3] - a[1]) / (b[1] - a[1]);
    snap = 3;
  } else if (edge & 4) {
    t = (bbox[1] - a[1]) / (b[1] - a[1]);
    snap = 1;
  } else if (edge & 2) {
    t = (bbox[2] - a[0]) / (b[0] - a[0]);
    snap = 2;
  } else if (edge & 1) {
    t = (bbox[0] - a[0]) / (b[0] - a[0]);
    snap = 0;
  } else {
    return null;
  }

  for (let i = 0; i < a.length; i++) {
    out[i] = (snap & 1) === i ? bbox[snap] : t * (b[i] - a[i]) + a[i];
  }

  return out;
}
export function bitCode(p, bbox) {
  let code = 0;
  if (p[0] < bbox[0]) code |= 1;else if (p[0] > bbox[2]) code |= 2;
  if (p[1] < bbox[1]) code |= 4;else if (p[1] > bbox[3]) code |= 8;
  return code;
}
//# sourceMappingURL=lineclip.js.map