import type { NumericArray } from '@math.gl/core';
export declare type BoundingBox = [number, number, number, number];
/**
 * Cohen-Sutherland line clipping algorithm, adapted to efficiently
 * handle polylines rather than just segments
 */
export declare function clipPolyline(positions: Readonly<NumericArray>, bbox: BoundingBox, options?: {
    size?: number;
    startIndex?: number;
    endIndex?: number;
}): number[][];
/**
 * Sutherland-Hodgeman polygon clipping algorithm
 * polygon must be closed (first vertex == last vertex)
 */
export declare function clipPolygon(positions: Readonly<NumericArray>, bbox: BoundingBox, options?: {
    size?: number;
    startIndex?: number;
    endIndex?: number;
}): number[];
/** intersect a segment against one of the 4 lines that make up the bbox */
export declare function intersect(a: number[], b: number[], edge: number, bbox: BoundingBox, out?: number[]): number[];
/**
 * bit code reflects the point position relative to the bbox:
 *         left  mid  right
 *    top  1001  1000  1010
 *    mid  0001  0000  0010
 * bottom  0101  0100  0110
 */
export declare function bitCode(p: number[], bbox: BoundingBox): number;
//# sourceMappingURL=lineclip.d.ts.map