/**
 * A constants class to maintain all the fixed variables.
 * @type {Object}
 */
module.exports = Object.freeze({
    /**
     * Built-in constants.
     */
    PI: Math.PI,
    E: Math.E,
    LN10: Math.LN10,
    LN2: Math.LN2,
    LOG10E: Math.LOG10E,
    LOG2E: Math.LOG2E,
    SQRT1_2: Math.SQRT1_2,
    SQRT2: Math.SQRT2,


    /**
     * Unit converter constants.
     */
    FEET_TO_INCHES_FACTOR:  12,
    FEET_TO_METERS_FACTOR: 0.3048,
    FEET_TO_MILES_FACTOR: 1 / 5280,
    FEET_TO_YARDS_FACTOR: 1 / 3,
    INCHES_TO_FEET_FACTOR: 1 / 12,
    INCHES_TO_METERS_FACTOR: 0.0254,
    INCHES_TO_MILES_FACTOR: 1 / 63360,
    INCHES_TO_YARDS_FACTOR: 1 / 36,
    MILES_TO_FEET_FACTOR: 5280,
    MILES_TO_INCHES_FACTOR: 63360,
    MILES_TO_METERS_FACTOR: 1609.344,
    MILES_TO_YARDS_FACTOR: 1760,
    YARDS_TO_INCHES_FACTOR: 36,
    YARDS_TO_FEET_FACTOR: 3,
    YARDS_TO_METERS_FACTOR: 0.9144,
    YARDS_TO_MILES_FACTOR: 1 / 1760,
    CELSIUS_TO_FAHRENEIT_MUTLIPLIER_FACTOR: 9 / 5,
    CELSIUS_TO_FAHRENEIT_FACTOR: 32


});
