# Function atan2

Calculate the inverse tangent function with two arguments, y/x.
By providing two arguments, the right quadrant of the computed angle can be
determined.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.atan2(y, x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`y` | Number &#124; Boolean &#124; Complex &#124; Array &#124; Matrix &#124; null | Second dimension
`x` | Number &#124; Boolean &#124; Complex &#124; Array &#124; Matrix &#124; null | First dimension

### Returns

Type | Description
---- | -----------
Number &#124; Complex &#124; Array &#124; Matrix | Four-quadrant inverse tangent


## Examples

```js
math.atan2(2, 2) / math.pi;       // returns number 0.25

var angle = math.unit(60, 'deg'); // returns Unit 60 deg
var x = math.cos(angle);
var y = math.sin(angle);

math.atan(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
```


## See also

[tan](tan.md),
[atan](atan.md),
[sin](sin.md),
[cos](cos.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
