# Function bitAnd

Bitwise AND two values, `x & y`.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.bitAnd(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | First value to and
`y` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Second value to and

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Array &#124; Matrix | AND of `x` and `y`


## Examples

```js
math.bitAnd(53, 131);               // returns Number 1

math.bitAnd([1, 12, 31], 42);       // returns Array [0, 8, 10]
```


## See also

[bitNot](bitNot.md),
[bitOr](bitOr.md),
[bitXor](bitXor.md),
[leftShift](leftShift.md),
[rightArithShift](rightArithShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
