# Function bitOr

Bitwise OR two values, `x | y`.
For matrices, the function is evaluated element wise.
For units, the function is evaluated on the lowest print base.


## Syntax

```js
math.bitOr(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | First value to or
`y` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Second value to or

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Array &#124; Matrix | OR of `x` and `y`


## Examples

```js
math.bitOr(1, 2);               // returns Number 3

math.bitOr([1, 2, 3], 4);       // returns Array [5, 6, 7]
```


## See also

[bitAnd](bitAnd.md),
[bitNot](bitNot.md),
[bitXor](bitXor.md),
[leftShift](leftShift.md),
[rightArithShift](rightArithShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
