# Function cos

Calculate the cosine of a value.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.cos(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | Function input

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | Cosine of x


## Examples

```js
math.cos(2);                      // returns Number -0.4161468365471422
math.cos(math.pi / 4);            // returns Number  0.7071067811865475
math.cos(math.unit(180, 'deg'));  // returns Number -1
math.cos(math.unit(60, 'deg'));   // returns Number  0.5

var angle = 0.2;
math.pow(math.sin(angle), 2) + math.pow(math.cos(angle), 2); // returns Number ~1
```


## See also

[cos](cos.md),
[tan](tan.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
