# Function import

Import functions from an object or a module


## Syntax

```js
math.import(object)
math.import(object, options)
```

### Where

- `object: Object`
  An object with functions to be imported.
- `options: Object` An object with import options. Available options:
  - `override: boolean`
    If true, existing functions will be overwritten. False by default.
  - `wrap: boolean`
    If true, the functions will be wrapped in a wrapper function
    which converts data types like Matrix to primitive data types like Array.
    The wrapper is needed when extending math.js with libraries which do not
    support these data types. False by default.

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`object` | String &#124; Object | Object with functions to be imported.
`options` | Object | Import options.

## Examples

```js
// define new functions and variables
math.import({
  myvalue: 42,
  hello: function (name) {
    return 'hello, ' + name + '!';
  }
});

// use the imported function and variable
math.myvalue * 2;               // 84
math.hello('user');             // 'hello, user!'

// import the npm module numbers
// (must be installed first with `npm install numbers`)
math.import('numbers', {wrap: true});

math.fibonacci(7); // returns 13
```




<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
