# Function log

Calculate the logarithm of a value.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.log(x)
math.log(x, base)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Array &#124; Matrix &#124; null |  Value for which to calculate the logarithm.
`base` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; null |  Optional base for the logarithm. If not provided, the natural logarithm of `x` is calculated. Default value: e.

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  Returns the logarithm of `x`


## Examples

```js
math.log(3.5);                  // returns 1.252762968495368
math.exp(math.log(2.4));        // returns 2.4

math.pow(10, 4);                // returns 10000
math.log(10000, 10);            // returns 4
math.log(10000) / math.log(10); // returns 4

math.log(1024, 2);              // returns 10
math.pow(2, 10);                // returns 1024
```


## See also

[exp](exp.md),
[log10](log10.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
