# Function to

Change the unit of a value.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.to(x, unit)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Unit &#124; Array &#124; Matrix | The unit to be converted.
`unit` | Unit &#124; Array &#124; Matrix | New unit. Can be a string like "cm" or a unit without value.

### Returns

Type | Description
---- | -----------
Unit &#124; Array &#124; Matrix | value with changed, fixed unit.


## Examples

```js
math.to(math.unit('2 inch'), 'cm');                   // returns Unit 5.08 cm
math.to(math.unit('2 inch'), math.unit(null, 'cm'));  // returns Unit 5.08 cm
math.to(math.unit(16, 'bytes'), 'bits');              // returns Unit 128 bits
```


## See also

[unit](unit.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
