# Function unequal

Test whether two values are unequal.

The function tests whether the relative difference between x and y is
larger than the configured epsilon. The function cannot be used to compare
values smaller than approximately 2.22e-16.

For matrices, the function is evaluated element wise.
In case of complex numbers, x.re must unequal y.re, or x.im must unequal y.im.

Values `null` and `undefined` are compared strictly, thus `null` is unequal
with everything except `null`, and `undefined` is unequal with everying
except. `undefined`.


## Syntax

```js
math.unequal(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; String &#124; Array &#124; Matrix &#124; null &#124; undefined | First value to compare
`y` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; String &#124; Array &#124; Matrix &#124; null &#124; undefined | Second value to compare

### Returns

Type | Description
---- | -----------
Boolean &#124; Array &#124; Matrix | Returns true when the compared values are unequal, else returns false


## Examples

```js
math.unequal(2 + 2, 3);       // returns true
math.unequal(2 + 2, 4);       // returns false

var a = math.unit('50 cm');
var b = math.unit('5 m');
math.unequal(a, b);           // returns false

var c = [2, 5, 1];
var d = [2, 7, 1];

math.unequal(c, d);           // returns [false, true, false]
math.deepEqual(c, d);         // returns false

math.unequal(0, null);        // returns true
```


## See also

[equal](equal.md),
[deepEqual](deepEqual.md),
[smaller](smaller.md),
[smallerEq](smallerEq.md),
[larger](larger.md),
[largerEq](largerEq.md),
[compare](compare.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
