<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function apply

Apply a function that maps an array to a scalar
along a given axis of a matrix or array.
Returns a new matrix or array with one less dimension than the input.


## Syntax

```js
math.apply(A, dim, callback)
```

### Where

- `dim: number` is a zero-based dimension over which to concatenate the matrices.

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`array` | Array &#124; Matrix | The input Matrix
`dim` | number | The dimension along which the callback is applied
`callback` | Function | The callback function that is applied. This Function should take an array or 1-d matrix as an input and return a number.

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | res    The residual matrix with the function applied over some dimension.


### Throws

Type | Description
---- | -----------


## Examples

```js
const A = [[1, 2], [3, 4]]
const sum = math.sum

math.apply(A, 0, sum)             // returns [4, 6]
math.apply(A, 1, sum)             // returns [3, 7]
```


## See also

[map](map.md),
[filter](filter.md),
[forEach](forEach.md)
