<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function cumsum

Compute the cumulative sum of a matrix or a list with values.
In case of a (multi dimensional) array or matrix, the cumulative sums
along a specified dimension (defaulting to the first) will be calculated.


## Syntax

```js
math.cumsum(a, b, c, ...)
math.cumsum(A)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... * | A single matrix or or multiple scalar values

### Returns

Type | Description
---- | -----------
* | The cumulative sum of all values


### Throws

Type | Description
---- | -----------


## Examples

```js
math.cumsum(2, 1, 4, 3)               // returns [2, 3, 7, 10]
math.cumsum([2, 1, 4, 3])             // returns [2, 3, 7, 10]
math.cumsum([[1, 2], [3, 4]])         // returns [[1, 2], [4, 6]]
math.cumsum([[1, 2], [3, 4]], 0)      // returns [[1, 2], [4, 6]]
math.cumsum([[1, 2], [3, 4]], 1)      // returns [[1, 3], [3, 7]]
math.cumsum([[2, 5], [4, 3], [1, 7]]) // returns [[2, 5], [6, 8], [7, 15]]
```


## See also

[mean](mean.md),
[median](median.md),
[min](min.md),
[max](max.md),
[prod](prod.md),
[std](std.md),
[variance](variance.md),
[sum](sum.md)
