<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function eigs

Compute eigenvalues and eigenvectors of a matrix. The eigenvalues are sorted by their absolute value, ascending.
An eigenvalue with multiplicity k will be listed k times. The eigenvectors are returned as columns of a matrix –
the eigenvector that belongs to the j-th eigenvalue in the list (eg. `values[j]`) is the j-th column (eg. `column(vectors, j)`).
If the algorithm fails to converge, it will throw an error – in that case, however, you may still find useful information
in `err.values` and `err.vectors`.


## Syntax

```js
math.eigs(x, [prec])
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Array &#124; Matrix | Matrix to be diagonalized
`prec` | number &#124; BigNumber | Precision, default value: 1e-15

### Returns

Type | Description
---- | -----------
{values: Array &#124; Matrix, vectors: Array &#124; Matrix} | Object containing an array of eigenvalues and a matrix with eigenvectors as columns.


### Throws

Type | Description
---- | -----------


## Examples

```js
const { eigs, multiply, column, transpose } = math
const H = [[5, 2.3], [2.3, 1]]
const ans = eigs(H) // returns {values: [E1,E2...sorted], vectors: [v1,v2.... corresponding vectors as columns]}
const E = ans.values
const U = ans.vectors
multiply(H, column(U, 0)) // returns multiply(E[0], column(U, 0))
const UTxHxU = multiply(transpose(U), H, U) // diagonalizes H
E[0] == UTxHxU[0][0]  // returns true
```


## See also

[inv](inv.md)
