<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function gcd

Calculate the greatest common divisor for two or more values or arrays.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.gcd(a, b)
math.gcd(a, b, c, ...)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... number &#124; BigNumber &#124; Fraction &#124; Array &#124; Matrix | Two or more integer numbers

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Array &#124; Matrix | The greatest common divisor


### Throws

Type | Description
---- | -----------


## Examples

```js
math.gcd(8, 12)              // returns 4
math.gcd(-4, 6)              // returns 2
math.gcd(25, 15, -10)        // returns 5

math.gcd([8, -4], [12, 6])   // returns [4, 2]
```


## See also

[lcm](lcm.md),
[xgcd](xgcd.md)
