<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function hasNumericValue

Test whether a value is an numeric value.

In case of a string, true is returned if the string contains a numeric value.


## Syntax

```js
math.hasNumericValue(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | * | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is a `number`, `BigNumber`, `Fraction`, `Boolean`, or a `String` containing number. Returns false for other types. Throws an error in case of unknown types.


### Throws

Type | Description
---- | -----------


## Examples

```js
math.hasNumericValue(2)                     // returns true
math.hasNumericValue('2')                   // returns true
math.isNumeric('2')                         // returns false
math.hasNumericValue(0)                     // returns true
math.hasNumericValue(math.bignumber(500))   // returns true
math.hasNumericValue(math.fraction(4))      // returns true
math.hasNumericValue(math.complex('2-4i')   // returns false
math.hasNumericValue([2.3, 'foo', false])   // returns [true, false, true]
```


## See also

[isZero](isZero.md),
[isPositive](isPositive.md),
[isNegative](isNegative.md),
[isInteger](isInteger.md),
[isNumeric](isNumeric.md)
