<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function invmod

Calculate the (modular) multiplicative inverse of a modulo b. Solution to the equation `ax ≣ 1 (mod b)`
See https://en.wikipedia.org/wiki/Modular_multiplicative_inverse.


## Syntax

```js
math.invmod(a, b)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`a` | number &#124; BigNumber | An integer number
`b` | number &#124; BigNumber | An integer number

### Returns

Type | Description
---- | -----------
number &#124; BigNumber | Returns an integer number where `invmod(a,b)*a ≣ 1 (mod b)`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.invmod(8, 12)             // returns NaN
math.invmod(7, 13)             // return 2
math.invmod(15151, 15122)      // returns 10429
```


## See also

[gcd](gcd.md),
[xgcd](xgcd.md)
