<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function isNaN

Test whether a value is NaN (not a number).
The function supports types `number`, `BigNumber`, `Fraction`, `Unit` and `Complex`.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isNaN(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Unit &#124; Array &#124; Matrix | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is NaN. Throws an error in case of an unknown data type.


### Throws

Type | Description
---- | -----------


## Examples

```js
math.isNaN(3)                     // returns false
math.isNaN(NaN)                   // returns true
math.isNaN(0)                     // returns false
math.isNaN(math.bignumber(NaN))   // returns true
math.isNaN(math.bignumber(0))     // returns false
math.isNaN(math.fraction(-2, 5))  // returns false
math.isNaN('-2')                  // returns false
math.isNaN([2, 0, -3, NaN]')      // returns [false, false, false, true]
```


## See also

[isNumeric](isNumeric.md),
[isNegative](isNegative.md),
[isPositive](isPositive.md),
[isZero](isZero.md),
[isInteger](isInteger.md)
