<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function isZero

Test whether a value is zero.
The function can check for zero for types `number`, `BigNumber`, `Fraction`,
`Complex`, and `Unit`.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isZero(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Fraction &#124; Unit &#124; Array &#124; Matrix | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is zero. Throws an error in case of an unknown data type.


### Throws

Type | Description
---- | -----------


## Examples

```js
math.isZero(0)                     // returns true
math.isZero(2)                     // returns false
math.isZero(0.5)                   // returns false
math.isZero(math.bignumber(0))     // returns true
math.isZero(math.fraction(0))      // returns true
math.isZero(math.fraction(1,3))    // returns false
math.isZero(math.complex('2 - 4i') // returns false
math.isZero(math.complex('0i')     // returns true
math.isZero('0')                   // returns true
math.isZero('2')                   // returns false
math.isZero([2, 0, -3]')           // returns [false, true, false]
```


## See also

[isNumeric](isNumeric.md),
[isPositive](isPositive.md),
[isNegative](isNegative.md),
[isInteger](isInteger.md)
