<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function largerEq

Test whether value x is larger or equal to y.

The function returns true when x is larger than y or the relative
difference between x and y is smaller than the configured epsilon. The
function cannot be used to compare values smaller than approximately 2.22e-16.

For matrices, the function is evaluated element wise.
Strings are compared by their numerical value.


## Syntax

```js
math.largerEq(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; boolean &#124; Unit &#124; string &#124; Array &#124; Matrix | First value to compare
`y` | number &#124; BigNumber &#124; Fraction &#124; boolean &#124; Unit &#124; string &#124; Array &#124; Matrix | Second value to compare

### Returns

Type | Description
---- | -----------
boolean &#124; Array &#124; Matrix | Returns true when the x is larger or equal to y, else returns false


### Throws

Type | Description
---- | -----------


## Examples

```js
math.larger(2, 1 + 1)         // returns false
math.largerEq(2, 1 + 1)       // returns true
```


## See also

[equal](equal.md),
[unequal](unequal.md),
[smaller](smaller.md),
[smallerEq](smallerEq.md),
[larger](larger.md),
[compare](compare.md)
