<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function leafCount

Gives the number of "leaf nodes" in the parse tree of the given expression
A leaf node is one that has no subexpressions, essentially either a
symbol or a constant. Note that `5!` has just one leaf, the '5'; the
unary factorial operator does not add a leaf. On the other hand,
function symbols do add leaves, so `sin(x)/cos(x)` has four leaves.

The `simplify()` function should generally not increase the `leafCount()`
of an expression, although currently there is no guarantee that it never
does so. In many cases, `simplify()` reduces the leaf count.


## Syntax

```js
leafCount(expr)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | Node &#124; string | The expression to count the leaves of

### Returns

Type | Description
---- | -----------
number | The number of leaves of `expr`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.leafCount('x') // 1
math.leafCount(math.parse('a*d-b*c')) // 4
math.leafCount('[a,b;c,d][0,1]') // 6
```


## See also

[simplify](simplify.md)
