<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function log10

Calculate the 10-base logarithm of a value. This is the same as calculating `log(x, 10)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.log10(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  Value for which to calculate the logarithm.

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  Returns the 10-base logarithm of `x`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.log10(0.00001)            // returns -5
math.log10(10000)              // returns 4
math.log(10000) / math.log(10) // returns 4
math.pow(10, 4)                // returns 10000
```


## See also

[exp](exp.md),
[log](log.md),
[log1p](log1p.md),
[log2](log2.md)
